// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// MachineKey of an app.
/// </summary>
public partial class SiteMachineKey : ProvisionableConstruct
{
    /// <summary>
    /// MachineKey validation.
    /// </summary>
    public BicepValue<string> Validation 
    {
        get { Initialize(); return _validation!; }
    }
    private BicepValue<string>? _validation;

    /// <summary>
    /// Validation key.
    /// </summary>
    public BicepValue<string> ValidationKey 
    {
        get { Initialize(); return _validationKey!; }
    }
    private BicepValue<string>? _validationKey;

    /// <summary>
    /// Algorithm used for decryption.
    /// </summary>
    public BicepValue<string> Decryption 
    {
        get { Initialize(); return _decryption!; }
    }
    private BicepValue<string>? _decryption;

    /// <summary>
    /// Decryption key.
    /// </summary>
    public BicepValue<string> DecryptionKey 
    {
        get { Initialize(); return _decryptionKey!; }
    }
    private BicepValue<string>? _decryptionKey;

    /// <summary>
    /// Creates a new SiteMachineKey.
    /// </summary>
    public SiteMachineKey()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteMachineKey.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _validation = DefineProperty<string>("Validation", ["validation"], isOutput: true);
        _validationKey = DefineProperty<string>("ValidationKey", ["validationKey"], isOutput: true);
        _decryption = DefineProperty<string>("Decryption", ["decryption"], isOutput: true);
        _decryptionKey = DefineProperty<string>("DecryptionKey", ["decryptionKey"], isOutput: true);
    }
}
