// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Metric limits set on an app.
/// </summary>
public partial class SiteLimits : ProvisionableConstruct
{
    /// <summary>
    /// Maximum allowed CPU usage percentage.
    /// </summary>
    public BicepValue<double> MaxPercentageCpu 
    {
        get { Initialize(); return _maxPercentageCpu!; }
        set { Initialize(); _maxPercentageCpu!.Assign(value); }
    }
    private BicepValue<double>? _maxPercentageCpu;

    /// <summary>
    /// Maximum allowed memory usage in MB.
    /// </summary>
    public BicepValue<long> MaxMemoryInMb 
    {
        get { Initialize(); return _maxMemoryInMb!; }
        set { Initialize(); _maxMemoryInMb!.Assign(value); }
    }
    private BicepValue<long>? _maxMemoryInMb;

    /// <summary>
    /// Maximum allowed disk size usage in MB.
    /// </summary>
    public BicepValue<long> MaxDiskSizeInMb 
    {
        get { Initialize(); return _maxDiskSizeInMb!; }
        set { Initialize(); _maxDiskSizeInMb!.Assign(value); }
    }
    private BicepValue<long>? _maxDiskSizeInMb;

    /// <summary>
    /// Creates a new SiteLimits.
    /// </summary>
    public SiteLimits()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteLimits.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _maxPercentageCpu = DefineProperty<double>("MaxPercentageCpu", ["maxPercentageCpu"]);
        _maxMemoryInMb = DefineProperty<long>("MaxMemoryInMb", ["maxMemoryInMb"]);
        _maxDiskSizeInMb = DefineProperty<long>("MaxDiskSizeInMb", ["maxDiskSizeInMb"]);
    }
}
