// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Configuration of an App Service app.
/// </summary>
public partial class SiteConfigProperties : ProvisionableConstruct
{
    /// <summary>
    /// Number of workers.
    /// </summary>
    public BicepValue<int> NumberOfWorkers 
    {
        get { Initialize(); return _numberOfWorkers!; }
        set { Initialize(); _numberOfWorkers!.Assign(value); }
    }
    private BicepValue<int>? _numberOfWorkers;

    /// <summary>
    /// Default documents.
    /// </summary>
    public BicepList<string> DefaultDocuments 
    {
        get { Initialize(); return _defaultDocuments!; }
        set { Initialize(); _defaultDocuments!.Assign(value); }
    }
    private BicepList<string>? _defaultDocuments;

    /// <summary>
    /// .NET Framework version.
    /// </summary>
    public BicepValue<string> NetFrameworkVersion 
    {
        get { Initialize(); return _netFrameworkVersion!; }
        set { Initialize(); _netFrameworkVersion!.Assign(value); }
    }
    private BicepValue<string>? _netFrameworkVersion;

    /// <summary>
    /// Version of PHP.
    /// </summary>
    public BicepValue<string> PhpVersion 
    {
        get { Initialize(); return _phpVersion!; }
        set { Initialize(); _phpVersion!.Assign(value); }
    }
    private BicepValue<string>? _phpVersion;

    /// <summary>
    /// Version of Python.
    /// </summary>
    public BicepValue<string> PythonVersion 
    {
        get { Initialize(); return _pythonVersion!; }
        set { Initialize(); _pythonVersion!.Assign(value); }
    }
    private BicepValue<string>? _pythonVersion;

    /// <summary>
    /// Version of Node.js.
    /// </summary>
    public BicepValue<string> NodeVersion 
    {
        get { Initialize(); return _nodeVersion!; }
        set { Initialize(); _nodeVersion!.Assign(value); }
    }
    private BicepValue<string>? _nodeVersion;

    /// <summary>
    /// Version of PowerShell.
    /// </summary>
    public BicepValue<string> PowerShellVersion 
    {
        get { Initialize(); return _powerShellVersion!; }
        set { Initialize(); _powerShellVersion!.Assign(value); }
    }
    private BicepValue<string>? _powerShellVersion;

    /// <summary>
    /// Linux App Framework and version.
    /// </summary>
    public BicepValue<string> LinuxFxVersion 
    {
        get { Initialize(); return _linuxFxVersion!; }
        set { Initialize(); _linuxFxVersion!.Assign(value); }
    }
    private BicepValue<string>? _linuxFxVersion;

    /// <summary>
    /// Xenon App Framework and version.
    /// </summary>
    public BicepValue<string> WindowsFxVersion 
    {
        get { Initialize(); return _windowsFxVersion!; }
        set { Initialize(); _windowsFxVersion!.Assign(value); }
    }
    private BicepValue<string>? _windowsFxVersion;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if request tracing is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsRequestTracingEnabled 
    {
        get { Initialize(); return _isRequestTracingEnabled!; }
        set { Initialize(); _isRequestTracingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRequestTracingEnabled;

    /// <summary>
    /// Request tracing expiration time.
    /// </summary>
    public BicepValue<DateTimeOffset> RequestTracingExpirationOn 
    {
        get { Initialize(); return _requestTracingExpirationOn!; }
        set { Initialize(); _requestTracingExpirationOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _requestTracingExpirationOn;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if remote debugging is enabled;
    /// otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsRemoteDebuggingEnabled 
    {
        get { Initialize(); return _isRemoteDebuggingEnabled!; }
        set { Initialize(); _isRemoteDebuggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRemoteDebuggingEnabled;

    /// <summary>
    /// Remote debugging version.
    /// </summary>
    public BicepValue<string> RemoteDebuggingVersion 
    {
        get { Initialize(); return _remoteDebuggingVersion!; }
        set { Initialize(); _remoteDebuggingVersion!.Assign(value); }
    }
    private BicepValue<string>? _remoteDebuggingVersion;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if HTTP logging is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsHttpLoggingEnabled 
    {
        get { Initialize(); return _isHttpLoggingEnabled!; }
        set { Initialize(); _isHttpLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isHttpLoggingEnabled;

    /// <summary>
    /// Flag to use Managed Identity Creds for ACR pull.
    /// </summary>
    public BicepValue<bool> UseManagedIdentityCreds 
    {
        get { Initialize(); return _useManagedIdentityCreds!; }
        set { Initialize(); _useManagedIdentityCreds!.Assign(value); }
    }
    private BicepValue<bool>? _useManagedIdentityCreds;

    /// <summary>
    /// If using user managed identity, the user managed identity ClientId.
    /// </summary>
    public BicepValue<string> AcrUserManagedIdentityId 
    {
        get { Initialize(); return _acrUserManagedIdentityId!; }
        set { Initialize(); _acrUserManagedIdentityId!.Assign(value); }
    }
    private BicepValue<string>? _acrUserManagedIdentityId;

    /// <summary>
    /// HTTP logs directory size limit.
    /// </summary>
    public BicepValue<int> LogsDirectorySizeLimit 
    {
        get { Initialize(); return _logsDirectorySizeLimit!; }
        set { Initialize(); _logsDirectorySizeLimit!.Assign(value); }
    }
    private BicepValue<int>? _logsDirectorySizeLimit;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if detailed error logging is enabled;
    /// otherwise, &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsDetailedErrorLoggingEnabled 
    {
        get { Initialize(); return _isDetailedErrorLoggingEnabled!; }
        set { Initialize(); _isDetailedErrorLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isDetailedErrorLoggingEnabled;

    /// <summary>
    /// Publishing user name.
    /// </summary>
    public BicepValue<string> PublishingUsername 
    {
        get { Initialize(); return _publishingUsername!; }
        set { Initialize(); _publishingUsername!.Assign(value); }
    }
    private BicepValue<string>? _publishingUsername;

    /// <summary>
    /// Application settings.
    /// </summary>
    public BicepList<AppServiceNameValuePair> AppSettings 
    {
        get { Initialize(); return _appSettings!; }
        set { Initialize(); _appSettings!.Assign(value); }
    }
    private BicepList<AppServiceNameValuePair>? _appSettings;

    /// <summary>
    /// Application metadata. This property cannot be retrieved, since it may
    /// contain secrets.
    /// </summary>
    public BicepList<AppServiceNameValuePair> Metadata 
    {
        get { Initialize(); return _metadata!; }
        set { Initialize(); _metadata!.Assign(value); }
    }
    private BicepList<AppServiceNameValuePair>? _metadata;

    /// <summary>
    /// Connection strings.
    /// </summary>
    public BicepList<ConnStringInfo> ConnectionStrings 
    {
        get { Initialize(); return _connectionStrings!; }
        set { Initialize(); _connectionStrings!.Assign(value); }
    }
    private BicepList<ConnStringInfo>? _connectionStrings;

    /// <summary>
    /// Site MachineKey.
    /// </summary>
    public SiteMachineKey MachineKey 
    {
        get { Initialize(); return _machineKey!; }
    }
    private SiteMachineKey? _machineKey;

    /// <summary>
    /// Handler mappings.
    /// </summary>
    public BicepList<HttpRequestHandlerMapping> HandlerMappings 
    {
        get { Initialize(); return _handlerMappings!; }
        set { Initialize(); _handlerMappings!.Assign(value); }
    }
    private BicepList<HttpRequestHandlerMapping>? _handlerMappings;

    /// <summary>
    /// Document root.
    /// </summary>
    public BicepValue<string> DocumentRoot 
    {
        get { Initialize(); return _documentRoot!; }
        set { Initialize(); _documentRoot!.Assign(value); }
    }
    private BicepValue<string>? _documentRoot;

    /// <summary>
    /// SCM type.
    /// </summary>
    public BicepValue<ScmType> ScmType 
    {
        get { Initialize(); return _scmType!; }
        set { Initialize(); _scmType!.Assign(value); }
    }
    private BicepValue<ScmType>? _scmType;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; to use 32-bit worker process; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> Use32BitWorkerProcess 
    {
        get { Initialize(); return _use32BitWorkerProcess!; }
        set { Initialize(); _use32BitWorkerProcess!.Assign(value); }
    }
    private BicepValue<bool>? _use32BitWorkerProcess;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if WebSocket is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsWebSocketsEnabled 
    {
        get { Initialize(); return _isWebSocketsEnabled!; }
        set { Initialize(); _isWebSocketsEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isWebSocketsEnabled;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if Always On is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsAlwaysOn 
    {
        get { Initialize(); return _isAlwaysOn!; }
        set { Initialize(); _isAlwaysOn!.Assign(value); }
    }
    private BicepValue<bool>? _isAlwaysOn;

    /// <summary>
    /// Java version.
    /// </summary>
    public BicepValue<string> JavaVersion 
    {
        get { Initialize(); return _javaVersion!; }
        set { Initialize(); _javaVersion!.Assign(value); }
    }
    private BicepValue<string>? _javaVersion;

    /// <summary>
    /// Java container.
    /// </summary>
    public BicepValue<string> JavaContainer 
    {
        get { Initialize(); return _javaContainer!; }
        set { Initialize(); _javaContainer!.Assign(value); }
    }
    private BicepValue<string>? _javaContainer;

    /// <summary>
    /// Java container version.
    /// </summary>
    public BicepValue<string> JavaContainerVersion 
    {
        get { Initialize(); return _javaContainerVersion!; }
        set { Initialize(); _javaContainerVersion!.Assign(value); }
    }
    private BicepValue<string>? _javaContainerVersion;

    /// <summary>
    /// App command line to launch.
    /// </summary>
    public BicepValue<string> AppCommandLine 
    {
        get { Initialize(); return _appCommandLine!; }
        set { Initialize(); _appCommandLine!.Assign(value); }
    }
    private BicepValue<string>? _appCommandLine;

    /// <summary>
    /// Managed pipeline mode.
    /// </summary>
    public BicepValue<ManagedPipelineMode> ManagedPipelineMode 
    {
        get { Initialize(); return _managedPipelineMode!; }
        set { Initialize(); _managedPipelineMode!.Assign(value); }
    }
    private BicepValue<ManagedPipelineMode>? _managedPipelineMode;

    /// <summary>
    /// Virtual applications.
    /// </summary>
    public BicepList<VirtualApplication> VirtualApplications 
    {
        get { Initialize(); return _virtualApplications!; }
        set { Initialize(); _virtualApplications!.Assign(value); }
    }
    private BicepList<VirtualApplication>? _virtualApplications;

    /// <summary>
    /// Site load balancing.
    /// </summary>
    public BicepValue<SiteLoadBalancing> LoadBalancing 
    {
        get { Initialize(); return _loadBalancing!; }
        set { Initialize(); _loadBalancing!.Assign(value); }
    }
    private BicepValue<SiteLoadBalancing>? _loadBalancing;

    /// <summary>
    /// List of ramp-up rules.
    /// </summary>
    public BicepList<RampUpRule> ExperimentsRampUpRules 
    {
        get { Initialize(); return _experimentsRampUpRules!; }
        set { Initialize(); _experimentsRampUpRules!.Assign(value); }
    }
    private BicepList<RampUpRule>? _experimentsRampUpRules;

    /// <summary>
    /// Site limits.
    /// </summary>
    public SiteLimits Limits 
    {
        get { Initialize(); return _limits!; }
        set { Initialize(); AssignOrReplace(ref _limits, value); }
    }
    private SiteLimits? _limits;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; if Auto Heal is enabled; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsAutoHealEnabled 
    {
        get { Initialize(); return _isAutoHealEnabled!; }
        set { Initialize(); _isAutoHealEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isAutoHealEnabled;

    /// <summary>
    /// Auto Heal rules.
    /// </summary>
    public AutoHealRules AutoHealRules 
    {
        get { Initialize(); return _autoHealRules!; }
        set { Initialize(); AssignOrReplace(ref _autoHealRules, value); }
    }
    private AutoHealRules? _autoHealRules;

    /// <summary>
    /// Tracing options.
    /// </summary>
    public BicepValue<string> TracingOptions 
    {
        get { Initialize(); return _tracingOptions!; }
        set { Initialize(); _tracingOptions!.Assign(value); }
    }
    private BicepValue<string>? _tracingOptions;

    /// <summary>
    /// Virtual Network name.
    /// </summary>
    public BicepValue<string> VnetName 
    {
        get { Initialize(); return _vnetName!; }
        set { Initialize(); _vnetName!.Assign(value); }
    }
    private BicepValue<string>? _vnetName;

    /// <summary>
    /// Virtual Network Route All enabled. This causes all outbound traffic to
    /// have Virtual Network Security Groups and User Defined Routes applied.
    /// </summary>
    public BicepValue<bool> IsVnetRouteAllEnabled 
    {
        get { Initialize(); return _isVnetRouteAllEnabled!; }
        set { Initialize(); _isVnetRouteAllEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isVnetRouteAllEnabled;

    /// <summary>
    /// The number of private ports assigned to this app. These will be
    /// assigned dynamically on runtime.
    /// </summary>
    public BicepValue<int> VnetPrivatePortsCount 
    {
        get { Initialize(); return _vnetPrivatePortsCount!; }
        set { Initialize(); _vnetPrivatePortsCount!.Assign(value); }
    }
    private BicepValue<int>? _vnetPrivatePortsCount;

    /// <summary>
    /// Cross-Origin Resource Sharing (CORS) settings.
    /// </summary>
    public AppServiceCorsSettings Cors 
    {
        get { Initialize(); return _cors!; }
        set { Initialize(); AssignOrReplace(ref _cors, value); }
    }
    private AppServiceCorsSettings? _cors;

    /// <summary>
    /// Push endpoint settings.
    /// </summary>
    public WebAppPushSettings Push 
    {
        get { Initialize(); return _push!; }
        set { Initialize(); AssignOrReplace(ref _push, value); }
    }
    private WebAppPushSettings? _push;

    /// <summary>
    /// The URL of the API definition.
    /// </summary>
    public BicepValue<Uri> ApiDefinitionUri 
    {
        get { Initialize(); return _apiDefinitionUri!; }
        set { Initialize(); _apiDefinitionUri!.Assign(value); }
    }
    private BicepValue<Uri>? _apiDefinitionUri;

    /// <summary>
    /// APIM-Api Identifier.
    /// </summary>
    public BicepValue<string> ApiManagementConfigId 
    {
        get { Initialize(); return _apiManagementConfigId!; }
        set { Initialize(); _apiManagementConfigId!.Assign(value); }
    }
    private BicepValue<string>? _apiManagementConfigId;

    /// <summary>
    /// Auto-swap slot name.
    /// </summary>
    public BicepValue<string> AutoSwapSlotName 
    {
        get { Initialize(); return _autoSwapSlotName!; }
        set { Initialize(); _autoSwapSlotName!.Assign(value); }
    }
    private BicepValue<string>? _autoSwapSlotName;

    /// <summary>
    /// &lt;code&gt;true&lt;/code&gt; to enable local MySQL; otherwise,
    /// &lt;code&gt;false&lt;/code&gt;.
    /// </summary>
    public BicepValue<bool> IsLocalMySqlEnabled 
    {
        get { Initialize(); return _isLocalMySqlEnabled!; }
        set { Initialize(); _isLocalMySqlEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isLocalMySqlEnabled;

    /// <summary>
    /// Managed Service Identity Id.
    /// </summary>
    public BicepValue<int> ManagedServiceIdentityId 
    {
        get { Initialize(); return _managedServiceIdentityId!; }
        set { Initialize(); _managedServiceIdentityId!.Assign(value); }
    }
    private BicepValue<int>? _managedServiceIdentityId;

    /// <summary>
    /// Explicit Managed Service Identity Id.
    /// </summary>
    public BicepValue<int> XManagedServiceIdentityId 
    {
        get { Initialize(); return _xManagedServiceIdentityId!; }
        set { Initialize(); _xManagedServiceIdentityId!.Assign(value); }
    }
    private BicepValue<int>? _xManagedServiceIdentityId;

    /// <summary>
    /// Identity to use for Key Vault Reference authentication.
    /// </summary>
    public BicepValue<string> KeyVaultReferenceIdentity 
    {
        get { Initialize(); return _keyVaultReferenceIdentity!; }
        set { Initialize(); _keyVaultReferenceIdentity!.Assign(value); }
    }
    private BicepValue<string>? _keyVaultReferenceIdentity;

    /// <summary>
    /// IP security restrictions for main.
    /// </summary>
    public BicepList<AppServiceIPSecurityRestriction> IPSecurityRestrictions 
    {
        get { Initialize(); return _iPSecurityRestrictions!; }
        set { Initialize(); _iPSecurityRestrictions!.Assign(value); }
    }
    private BicepList<AppServiceIPSecurityRestriction>? _iPSecurityRestrictions;

    /// <summary>
    /// Default action for main access restriction if no rules are matched.
    /// </summary>
    public BicepValue<SiteDefaultAction> IPSecurityRestrictionsDefaultAction 
    {
        get { Initialize(); return _iPSecurityRestrictionsDefaultAction!; }
        set { Initialize(); _iPSecurityRestrictionsDefaultAction!.Assign(value); }
    }
    private BicepValue<SiteDefaultAction>? _iPSecurityRestrictionsDefaultAction;

    /// <summary>
    /// IP security restrictions for scm.
    /// </summary>
    public BicepList<AppServiceIPSecurityRestriction> ScmIPSecurityRestrictions 
    {
        get { Initialize(); return _scmIPSecurityRestrictions!; }
        set { Initialize(); _scmIPSecurityRestrictions!.Assign(value); }
    }
    private BicepList<AppServiceIPSecurityRestriction>? _scmIPSecurityRestrictions;

    /// <summary>
    /// Default action for scm access restriction if no rules are matched.
    /// </summary>
    public BicepValue<SiteDefaultAction> ScmIPSecurityRestrictionsDefaultAction 
    {
        get { Initialize(); return _scmIPSecurityRestrictionsDefaultAction!; }
        set { Initialize(); _scmIPSecurityRestrictionsDefaultAction!.Assign(value); }
    }
    private BicepValue<SiteDefaultAction>? _scmIPSecurityRestrictionsDefaultAction;

    /// <summary>
    /// IP security restrictions for scm to use main.
    /// </summary>
    public BicepValue<bool> AllowIPSecurityRestrictionsForScmToUseMain 
    {
        get { Initialize(); return _allowIPSecurityRestrictionsForScmToUseMain!; }
        set { Initialize(); _allowIPSecurityRestrictionsForScmToUseMain!.Assign(value); }
    }
    private BicepValue<bool>? _allowIPSecurityRestrictionsForScmToUseMain;

    /// <summary>
    /// Http20Enabled: configures a web site to allow clients to connect over
    /// http2.0.
    /// </summary>
    public BicepValue<bool> IsHttp20Enabled 
    {
        get { Initialize(); return _isHttp20Enabled!; }
        set { Initialize(); _isHttp20Enabled!.Assign(value); }
    }
    private BicepValue<bool>? _isHttp20Enabled;

    /// <summary>
    /// MinTlsVersion: configures the minimum version of TLS required for SSL
    /// requests.
    /// </summary>
    public BicepValue<AppServiceSupportedTlsVersion> MinTlsVersion 
    {
        get { Initialize(); return _minTlsVersion!; }
        set { Initialize(); _minTlsVersion!.Assign(value); }
    }
    private BicepValue<AppServiceSupportedTlsVersion>? _minTlsVersion;

    /// <summary>
    /// The minimum strength TLS cipher suite allowed for an application.
    /// </summary>
    public BicepValue<AppServiceTlsCipherSuite> MinTlsCipherSuite 
    {
        get { Initialize(); return _minTlsCipherSuite!; }
        set { Initialize(); _minTlsCipherSuite!.Assign(value); }
    }
    private BicepValue<AppServiceTlsCipherSuite>? _minTlsCipherSuite;

    /// <summary>
    /// ScmMinTlsVersion: configures the minimum version of TLS required for
    /// SSL requests for SCM site.
    /// </summary>
    public BicepValue<AppServiceSupportedTlsVersion> ScmMinTlsVersion 
    {
        get { Initialize(); return _scmMinTlsVersion!; }
        set { Initialize(); _scmMinTlsVersion!.Assign(value); }
    }
    private BicepValue<AppServiceSupportedTlsVersion>? _scmMinTlsVersion;

    /// <summary>
    /// State of FTP / FTPS service.
    /// </summary>
    public BicepValue<AppServiceFtpsState> FtpsState 
    {
        get { Initialize(); return _ftpsState!; }
        set { Initialize(); _ftpsState!.Assign(value); }
    }
    private BicepValue<AppServiceFtpsState>? _ftpsState;

    /// <summary>
    /// Number of preWarmed instances.             This setting only applies to
    /// the Consumption and Elastic Plans
    /// </summary>
    public BicepValue<int> PreWarmedInstanceCount 
    {
        get { Initialize(); return _preWarmedInstanceCount!; }
        set { Initialize(); _preWarmedInstanceCount!.Assign(value); }
    }
    private BicepValue<int>? _preWarmedInstanceCount;

    /// <summary>
    /// Maximum number of workers that a site can scale out to.
    /// This setting only applies to the Consumption and Elastic
    /// Premium Plans
    /// </summary>
    public BicepValue<int> FunctionAppScaleLimit 
    {
        get { Initialize(); return _functionAppScaleLimit!; }
        set { Initialize(); _functionAppScaleLimit!.Assign(value); }
    }
    private BicepValue<int>? _functionAppScaleLimit;

    /// <summary>
    /// Maximum number of workers that a site can scale out to.
    /// This setting only applies to apps in plans where
    /// ElasticScaleEnabled is &lt;code&gt;true&lt;/code&gt;
    /// </summary>
    public BicepValue<int> ElasticWebAppScaleLimit 
    {
        get { Initialize(); return _elasticWebAppScaleLimit!; }
        set { Initialize(); _elasticWebAppScaleLimit!.Assign(value); }
    }
    private BicepValue<int>? _elasticWebAppScaleLimit;

    /// <summary>
    /// Health check path.
    /// </summary>
    public BicepValue<string> HealthCheckPath 
    {
        get { Initialize(); return _healthCheckPath!; }
        set { Initialize(); _healthCheckPath!.Assign(value); }
    }
    private BicepValue<string>? _healthCheckPath;

    /// <summary>
    /// Gets or sets a value indicating whether functions runtime scale
    /// monitoring is enabled. When enabled,             the ScaleController
    /// will not monitor event sources directly, but will instead call to the
    /// runtime to get scale status.
    /// </summary>
    public BicepValue<bool> IsFunctionsRuntimeScaleMonitoringEnabled 
    {
        get { Initialize(); return _isFunctionsRuntimeScaleMonitoringEnabled!; }
        set { Initialize(); _isFunctionsRuntimeScaleMonitoringEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isFunctionsRuntimeScaleMonitoringEnabled;

    /// <summary>
    /// Sets the time zone a site uses for generating timestamps. Compatible
    /// with Linux and Windows App Service. Setting the WEBSITE_TIME_ZONE app
    /// setting takes precedence over this config. For Linux, expects tz
    /// database values https://www.iana.org/time-zones (for a quick reference
    /// see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones). For
    /// Windows, expects one of the time zones listed under
    /// HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Time
    /// Zones.
    /// </summary>
    public BicepValue<string> WebsiteTimeZone 
    {
        get { Initialize(); return _websiteTimeZone!; }
        set { Initialize(); _websiteTimeZone!.Assign(value); }
    }
    private BicepValue<string>? _websiteTimeZone;

    /// <summary>
    /// Number of minimum instance count for a site             This setting
    /// only applies to the Elastic Plans
    /// </summary>
    public BicepValue<int> MinimumElasticInstanceCount 
    {
        get { Initialize(); return _minimumElasticInstanceCount!; }
        set { Initialize(); _minimumElasticInstanceCount!.Assign(value); }
    }
    private BicepValue<int>? _minimumElasticInstanceCount;

    /// <summary>
    /// List of Azure Storage Accounts.
    /// </summary>
    public BicepDictionary<AppServiceStorageAccessInfo> AzureStorageAccounts 
    {
        get { Initialize(); return _azureStorageAccounts!; }
        set { Initialize(); _azureStorageAccounts!.Assign(value); }
    }
    private BicepDictionary<AppServiceStorageAccessInfo>? _azureStorageAccounts;

    /// <summary>
    /// Property to allow or block all public traffic.
    /// </summary>
    public BicepValue<string> PublicNetworkAccess 
    {
        get { Initialize(); return _publicNetworkAccess!; }
        set { Initialize(); _publicNetworkAccess!.Assign(value); }
    }
    private BicepValue<string>? _publicNetworkAccess;

    /// <summary>
    /// Creates a new SiteConfigProperties.
    /// </summary>
    public SiteConfigProperties()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of SiteConfigProperties.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _numberOfWorkers = DefineProperty<int>("NumberOfWorkers", ["numberOfWorkers"]);
        _defaultDocuments = DefineListProperty<string>("DefaultDocuments", ["defaultDocuments"]);
        _netFrameworkVersion = DefineProperty<string>("NetFrameworkVersion", ["netFrameworkVersion"]);
        _phpVersion = DefineProperty<string>("PhpVersion", ["phpVersion"]);
        _pythonVersion = DefineProperty<string>("PythonVersion", ["pythonVersion"]);
        _nodeVersion = DefineProperty<string>("NodeVersion", ["nodeVersion"]);
        _powerShellVersion = DefineProperty<string>("PowerShellVersion", ["powerShellVersion"]);
        _linuxFxVersion = DefineProperty<string>("LinuxFxVersion", ["linuxFxVersion"]);
        _windowsFxVersion = DefineProperty<string>("WindowsFxVersion", ["windowsFxVersion"]);
        _isRequestTracingEnabled = DefineProperty<bool>("IsRequestTracingEnabled", ["requestTracingEnabled"]);
        _requestTracingExpirationOn = DefineProperty<DateTimeOffset>("RequestTracingExpirationOn", ["requestTracingExpirationTime"]);
        _isRemoteDebuggingEnabled = DefineProperty<bool>("IsRemoteDebuggingEnabled", ["remoteDebuggingEnabled"]);
        _remoteDebuggingVersion = DefineProperty<string>("RemoteDebuggingVersion", ["remoteDebuggingVersion"]);
        _isHttpLoggingEnabled = DefineProperty<bool>("IsHttpLoggingEnabled", ["httpLoggingEnabled"]);
        _useManagedIdentityCreds = DefineProperty<bool>("UseManagedIdentityCreds", ["acrUseManagedIdentityCreds"]);
        _acrUserManagedIdentityId = DefineProperty<string>("AcrUserManagedIdentityId", ["acrUserManagedIdentityID"]);
        _logsDirectorySizeLimit = DefineProperty<int>("LogsDirectorySizeLimit", ["logsDirectorySizeLimit"]);
        _isDetailedErrorLoggingEnabled = DefineProperty<bool>("IsDetailedErrorLoggingEnabled", ["detailedErrorLoggingEnabled"]);
        _publishingUsername = DefineProperty<string>("PublishingUsername", ["publishingUsername"]);
        _appSettings = DefineListProperty<AppServiceNameValuePair>("AppSettings", ["appSettings"]);
        _metadata = DefineListProperty<AppServiceNameValuePair>("Metadata", ["metadata"]);
        _connectionStrings = DefineListProperty<ConnStringInfo>("ConnectionStrings", ["connectionStrings"]);
        _machineKey = DefineModelProperty<SiteMachineKey>("MachineKey", ["machineKey"], isOutput: true);
        _handlerMappings = DefineListProperty<HttpRequestHandlerMapping>("HandlerMappings", ["handlerMappings"]);
        _documentRoot = DefineProperty<string>("DocumentRoot", ["documentRoot"]);
        _scmType = DefineProperty<ScmType>("ScmType", ["scmType"]);
        _use32BitWorkerProcess = DefineProperty<bool>("Use32BitWorkerProcess", ["use32BitWorkerProcess"]);
        _isWebSocketsEnabled = DefineProperty<bool>("IsWebSocketsEnabled", ["webSocketsEnabled"]);
        _isAlwaysOn = DefineProperty<bool>("IsAlwaysOn", ["alwaysOn"]);
        _javaVersion = DefineProperty<string>("JavaVersion", ["javaVersion"]);
        _javaContainer = DefineProperty<string>("JavaContainer", ["javaContainer"]);
        _javaContainerVersion = DefineProperty<string>("JavaContainerVersion", ["javaContainerVersion"]);
        _appCommandLine = DefineProperty<string>("AppCommandLine", ["appCommandLine"]);
        _managedPipelineMode = DefineProperty<ManagedPipelineMode>("ManagedPipelineMode", ["managedPipelineMode"]);
        _virtualApplications = DefineListProperty<VirtualApplication>("VirtualApplications", ["virtualApplications"]);
        _loadBalancing = DefineProperty<SiteLoadBalancing>("LoadBalancing", ["loadBalancing"]);
        _experimentsRampUpRules = DefineListProperty<RampUpRule>("ExperimentsRampUpRules", ["experiments", "rampUpRules"]);
        _limits = DefineModelProperty<SiteLimits>("Limits", ["limits"]);
        _isAutoHealEnabled = DefineProperty<bool>("IsAutoHealEnabled", ["autoHealEnabled"]);
        _autoHealRules = DefineModelProperty<AutoHealRules>("AutoHealRules", ["autoHealRules"]);
        _tracingOptions = DefineProperty<string>("TracingOptions", ["tracingOptions"]);
        _vnetName = DefineProperty<string>("VnetName", ["vnetName"]);
        _isVnetRouteAllEnabled = DefineProperty<bool>("IsVnetRouteAllEnabled", ["vnetRouteAllEnabled"]);
        _vnetPrivatePortsCount = DefineProperty<int>("VnetPrivatePortsCount", ["vnetPrivatePortsCount"]);
        _cors = DefineModelProperty<AppServiceCorsSettings>("Cors", ["cors"]);
        _push = DefineModelProperty<WebAppPushSettings>("Push", ["push"]);
        _apiDefinitionUri = DefineProperty<Uri>("ApiDefinitionUri", ["apiDefinition", "url"]);
        _apiManagementConfigId = DefineProperty<string>("ApiManagementConfigId", ["apiManagementConfig", "id"]);
        _autoSwapSlotName = DefineProperty<string>("AutoSwapSlotName", ["autoSwapSlotName"]);
        _isLocalMySqlEnabled = DefineProperty<bool>("IsLocalMySqlEnabled", ["localMySqlEnabled"]);
        _managedServiceIdentityId = DefineProperty<int>("ManagedServiceIdentityId", ["managedServiceIdentityId"]);
        _xManagedServiceIdentityId = DefineProperty<int>("XManagedServiceIdentityId", ["xManagedServiceIdentityId"]);
        _keyVaultReferenceIdentity = DefineProperty<string>("KeyVaultReferenceIdentity", ["keyVaultReferenceIdentity"]);
        _iPSecurityRestrictions = DefineListProperty<AppServiceIPSecurityRestriction>("IPSecurityRestrictions", ["ipSecurityRestrictions"]);
        _iPSecurityRestrictionsDefaultAction = DefineProperty<SiteDefaultAction>("IPSecurityRestrictionsDefaultAction", ["ipSecurityRestrictionsDefaultAction"]);
        _scmIPSecurityRestrictions = DefineListProperty<AppServiceIPSecurityRestriction>("ScmIPSecurityRestrictions", ["scmIpSecurityRestrictions"]);
        _scmIPSecurityRestrictionsDefaultAction = DefineProperty<SiteDefaultAction>("ScmIPSecurityRestrictionsDefaultAction", ["scmIpSecurityRestrictionsDefaultAction"]);
        _allowIPSecurityRestrictionsForScmToUseMain = DefineProperty<bool>("AllowIPSecurityRestrictionsForScmToUseMain", ["scmIpSecurityRestrictionsUseMain"]);
        _isHttp20Enabled = DefineProperty<bool>("IsHttp20Enabled", ["http20Enabled"]);
        _minTlsVersion = DefineProperty<AppServiceSupportedTlsVersion>("MinTlsVersion", ["minTlsVersion"]);
        _minTlsCipherSuite = DefineProperty<AppServiceTlsCipherSuite>("MinTlsCipherSuite", ["minTlsCipherSuite"]);
        _scmMinTlsVersion = DefineProperty<AppServiceSupportedTlsVersion>("ScmMinTlsVersion", ["scmMinTlsVersion"]);
        _ftpsState = DefineProperty<AppServiceFtpsState>("FtpsState", ["ftpsState"]);
        _preWarmedInstanceCount = DefineProperty<int>("PreWarmedInstanceCount", ["preWarmedInstanceCount"]);
        _functionAppScaleLimit = DefineProperty<int>("FunctionAppScaleLimit", ["functionAppScaleLimit"]);
        _elasticWebAppScaleLimit = DefineProperty<int>("ElasticWebAppScaleLimit", ["elasticWebAppScaleLimit"]);
        _healthCheckPath = DefineProperty<string>("HealthCheckPath", ["healthCheckPath"]);
        _isFunctionsRuntimeScaleMonitoringEnabled = DefineProperty<bool>("IsFunctionsRuntimeScaleMonitoringEnabled", ["functionsRuntimeScaleMonitoringEnabled"]);
        _websiteTimeZone = DefineProperty<string>("WebsiteTimeZone", ["websiteTimeZone"]);
        _minimumElasticInstanceCount = DefineProperty<int>("MinimumElasticInstanceCount", ["minimumElasticInstanceCount"]);
        _azureStorageAccounts = DefineDictionaryProperty<AppServiceStorageAccessInfo>("AzureStorageAccounts", ["azureStorageAccounts"]);
        _publicNetworkAccess = DefineProperty<string>("PublicNetworkAccess", ["publicNetworkAccess"]);
    }
}
