// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure;
using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Message envelope that contains the common Azure resource manager properties
/// and the resource provider specific content.
/// </summary>
public partial class ResponseMessageEnvelopeRemotePrivateEndpointConnection : ProvisionableConstruct
{
    /// <summary>
    /// Azure-AsyncOperation Error info.
    /// </summary>
    public BicepValue<ResponseError> Error 
    {
        get { Initialize(); return _error!; }
    }
    private BicepValue<ResponseError>? _error;

    /// <summary>
    /// Geographical region resource belongs to e.g. SouthCentralUS,
    /// SouthEastAsia.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Tags associated with resource.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Azure resource manager plan.
    /// </summary>
    public AppServiceArmPlan Plan 
    {
        get { Initialize(); return _plan!; }
    }
    private AppServiceArmPlan? _plan;

    /// <summary>
    /// Resource specific properties.
    /// </summary>
    public RemotePrivateEndpointConnection Properties 
    {
        get { Initialize(); return _properties!; }
    }
    private RemotePrivateEndpointConnection? _properties;

    /// <summary>
    /// SKU description of the resource.
    /// </summary>
    public AppServiceSkuDescription Sku 
    {
        get { Initialize(); return _sku!; }
    }
    private AppServiceSkuDescription? _sku;

    /// <summary>
    /// Azure-AsyncOperation Status info.
    /// </summary>
    public BicepValue<string> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<string>? _status;

    /// <summary>
    /// MSI resource.
    /// </summary>
    public ManagedServiceIdentity Identity 
    {
        get { Initialize(); return _identity!; }
    }
    private ManagedServiceIdentity? _identity;

    /// <summary>
    /// Logical Availability Zones the service is hosted in.
    /// </summary>
    public BicepList<string> Zones 
    {
        get { Initialize(); return _zones!; }
    }
    private BicepList<string>? _zones;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new ResponseMessageEnvelopeRemotePrivateEndpointConnection.
    /// </summary>
    public ResponseMessageEnvelopeRemotePrivateEndpointConnection()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// ResponseMessageEnvelopeRemotePrivateEndpointConnection.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _error = DefineProperty<ResponseError>("Error", ["error"], isOutput: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isOutput: true);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"], isOutput: true);
        _plan = DefineModelProperty<AppServiceArmPlan>("Plan", ["plan"], isOutput: true);
        _properties = DefineModelProperty<RemotePrivateEndpointConnection>("Properties", ["properties"], isOutput: true);
        _sku = DefineModelProperty<AppServiceSkuDescription>("Sku", ["sku"], isOutput: true);
        _status = DefineProperty<string>("Status", ["status"], isOutput: true);
        _identity = DefineModelProperty<ManagedServiceIdentity>("Identity", ["identity"], isOutput: true);
        _zones = DefineListProperty<string>("Zones", ["zones"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
