// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Trigger based on total requests.
/// </summary>
public partial class RequestsBasedTrigger : ProvisionableConstruct
{
    /// <summary>
    /// Request Count.
    /// </summary>
    public BicepValue<int> Count 
    {
        get { Initialize(); return _count!; }
        set { Initialize(); _count!.Assign(value); }
    }
    private BicepValue<int>? _count;

    /// <summary>
    /// Time interval.
    /// </summary>
    public BicepValue<string> TimeInterval 
    {
        get { Initialize(); return _timeInterval!; }
        set { Initialize(); _timeInterval!.Assign(value); }
    }
    private BicepValue<string>? _timeInterval;

    /// <summary>
    /// Creates a new RequestsBasedTrigger.
    /// </summary>
    public RequestsBasedTrigger()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RequestsBasedTrigger.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _count = DefineProperty<int>("Count", ["count"]);
        _timeInterval = DefineProperty<string>("TimeInterval", ["timeInterval"]);
    }
}
