// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppService;

/// <summary>
/// A remote private endpoint connection.
/// </summary>
public partial class RemotePrivateEndpointConnection : ProvisionableConstruct
{
    /// <summary>
    /// Gets the provisioning state.
    /// </summary>
    public BicepValue<string> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<string>? _provisioningState;

    /// <summary>
    /// Gets Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> PrivateEndpointId 
    {
        get { Initialize(); return _privateEndpointId!; }
    }
    private BicepValue<ResourceIdentifier>? _privateEndpointId;

    /// <summary>
    /// The state of a private link connection.
    /// </summary>
    public PrivateLinkConnectionState PrivateLinkServiceConnectionState 
    {
        get { Initialize(); return _privateLinkServiceConnectionState!; }
        set { Initialize(); AssignOrReplace(ref _privateLinkServiceConnectionState, value); }
    }
    private PrivateLinkConnectionState? _privateLinkServiceConnectionState;

    /// <summary>
    /// Private IPAddresses mapped to the remote private endpoint.
    /// </summary>
    public BicepList<IPAddress> IPAddresses 
    {
        get { Initialize(); return _iPAddresses!; }
        set { Initialize(); _iPAddresses!.Assign(value); }
    }
    private BicepList<IPAddress>? _iPAddresses;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new RemotePrivateEndpointConnection.
    /// </summary>
    public RemotePrivateEndpointConnection()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// RemotePrivateEndpointConnection.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _provisioningState = DefineProperty<string>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _privateEndpointId = DefineProperty<ResourceIdentifier>("PrivateEndpointId", ["properties", "privateEndpoint", "id"], isOutput: true);
        _privateLinkServiceConnectionState = DefineModelProperty<PrivateLinkConnectionState>("PrivateLinkServiceConnectionState", ["properties", "privateLinkServiceConnectionState"]);
        _iPAddresses = DefineListProperty<IPAddress>("IPAddresses", ["properties", "ipAddresses"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
