// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Contact information for domain registration. If &apos;Domain Privacy&apos;
/// option is not selected then the contact information is made publicly
/// available through the Whois             directories as per ICANN
/// requirements.
/// </summary>
public partial class RegistrationContactInfo : ProvisionableConstruct
{
    /// <summary>
    /// Mailing address.
    /// </summary>
    public RegistrationAddressInfo AddressMailing 
    {
        get { Initialize(); return _addressMailing!; }
        set { Initialize(); AssignOrReplace(ref _addressMailing, value); }
    }
    private RegistrationAddressInfo? _addressMailing;

    /// <summary>
    /// Email address.
    /// </summary>
    public BicepValue<string> Email 
    {
        get { Initialize(); return _email!; }
        set { Initialize(); _email!.Assign(value); }
    }
    private BicepValue<string>? _email;

    /// <summary>
    /// Fax number.
    /// </summary>
    public BicepValue<string> Fax 
    {
        get { Initialize(); return _fax!; }
        set { Initialize(); _fax!.Assign(value); }
    }
    private BicepValue<string>? _fax;

    /// <summary>
    /// Job title.
    /// </summary>
    public BicepValue<string> JobTitle 
    {
        get { Initialize(); return _jobTitle!; }
        set { Initialize(); _jobTitle!.Assign(value); }
    }
    private BicepValue<string>? _jobTitle;

    /// <summary>
    /// First name.
    /// </summary>
    public BicepValue<string> NameFirst 
    {
        get { Initialize(); return _nameFirst!; }
        set { Initialize(); _nameFirst!.Assign(value); }
    }
    private BicepValue<string>? _nameFirst;

    /// <summary>
    /// Last name.
    /// </summary>
    public BicepValue<string> NameLast 
    {
        get { Initialize(); return _nameLast!; }
        set { Initialize(); _nameLast!.Assign(value); }
    }
    private BicepValue<string>? _nameLast;

    /// <summary>
    /// Middle name.
    /// </summary>
    public BicepValue<string> NameMiddle 
    {
        get { Initialize(); return _nameMiddle!; }
        set { Initialize(); _nameMiddle!.Assign(value); }
    }
    private BicepValue<string>? _nameMiddle;

    /// <summary>
    /// Organization contact belongs to.
    /// </summary>
    public BicepValue<string> Organization 
    {
        get { Initialize(); return _organization!; }
        set { Initialize(); _organization!.Assign(value); }
    }
    private BicepValue<string>? _organization;

    /// <summary>
    /// Phone number.
    /// </summary>
    public BicepValue<string> Phone 
    {
        get { Initialize(); return _phone!; }
        set { Initialize(); _phone!.Assign(value); }
    }
    private BicepValue<string>? _phone;

    /// <summary>
    /// Creates a new RegistrationContactInfo.
    /// </summary>
    public RegistrationContactInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RegistrationContactInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _addressMailing = DefineModelProperty<RegistrationAddressInfo>("AddressMailing", ["addressMailing"]);
        _email = DefineProperty<string>("Email", ["email"]);
        _fax = DefineProperty<string>("Fax", ["fax"]);
        _jobTitle = DefineProperty<string>("JobTitle", ["jobTitle"]);
        _nameFirst = DefineProperty<string>("NameFirst", ["nameFirst"]);
        _nameLast = DefineProperty<string>("NameLast", ["nameLast"]);
        _nameMiddle = DefineProperty<string>("NameMiddle", ["nameMiddle"]);
        _organization = DefineProperty<string>("Organization", ["organization"]);
        _phone = DefineProperty<string>("Phone", ["phone"]);
    }
}
