// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Address information for domain registration.
/// </summary>
public partial class RegistrationAddressInfo : ProvisionableConstruct
{
    /// <summary>
    /// First line of an Address.
    /// </summary>
    public BicepValue<string> Address1 
    {
        get { Initialize(); return _address1!; }
        set { Initialize(); _address1!.Assign(value); }
    }
    private BicepValue<string>? _address1;

    /// <summary>
    /// The second line of the Address. Optional.
    /// </summary>
    public BicepValue<string> Address2 
    {
        get { Initialize(); return _address2!; }
        set { Initialize(); _address2!.Assign(value); }
    }
    private BicepValue<string>? _address2;

    /// <summary>
    /// The city for the address.
    /// </summary>
    public BicepValue<string> City 
    {
        get { Initialize(); return _city!; }
        set { Initialize(); _city!.Assign(value); }
    }
    private BicepValue<string>? _city;

    /// <summary>
    /// The country for the address.
    /// </summary>
    public BicepValue<string> Country 
    {
        get { Initialize(); return _country!; }
        set { Initialize(); _country!.Assign(value); }
    }
    private BicepValue<string>? _country;

    /// <summary>
    /// The postal code for the address.
    /// </summary>
    public BicepValue<string> PostalCode 
    {
        get { Initialize(); return _postalCode!; }
        set { Initialize(); _postalCode!.Assign(value); }
    }
    private BicepValue<string>? _postalCode;

    /// <summary>
    /// The state or province for the address.
    /// </summary>
    public BicepValue<string> State 
    {
        get { Initialize(); return _state!; }
        set { Initialize(); _state!.Assign(value); }
    }
    private BicepValue<string>? _state;

    /// <summary>
    /// Creates a new RegistrationAddressInfo.
    /// </summary>
    public RegistrationAddressInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RegistrationAddressInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _address1 = DefineProperty<string>("Address1", ["address1"]);
        _address2 = DefineProperty<string>("Address2", ["address2"]);
        _city = DefineProperty<string>("City", ["city"]);
        _country = DefineProperty<string>("Country", ["country"]);
        _postalCode = DefineProperty<string>("PostalCode", ["postalCode"]);
        _state = DefineProperty<string>("State", ["state"]);
    }
}
