// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Routing rules for ramp up testing. This rule allows to redirect static
/// traffic % to a slot or to gradually change routing % based on performance.
/// </summary>
public partial class RampUpRule : ProvisionableConstruct
{
    /// <summary>
    /// Hostname of a slot to which the traffic will be redirected if decided
    /// to. E.g. myapp-stage.azurewebsites.net.
    /// </summary>
    public BicepValue<string> ActionHostName 
    {
        get { Initialize(); return _actionHostName!; }
        set { Initialize(); _actionHostName!.Assign(value); }
    }
    private BicepValue<string>? _actionHostName;

    /// <summary>
    /// Percentage of the traffic which will be redirected to
    /// &lt;code&gt;ActionHostName&lt;/code&gt;.
    /// </summary>
    public BicepValue<double> ReroutePercentage 
    {
        get { Initialize(); return _reroutePercentage!; }
        set { Initialize(); _reroutePercentage!.Assign(value); }
    }
    private BicepValue<double>? _reroutePercentage;

    /// <summary>
    /// In auto ramp up scenario this is the step to add/remove from
    /// &lt;code&gt;ReroutePercentage&lt;/code&gt; until it reaches
    /// \n&lt;code&gt;MinReroutePercentage&lt;/code&gt; or
    /// &lt;code&gt;MaxReroutePercentage&lt;/code&gt;. Site
    /// metrics are checked every N minutes specified in
    /// &lt;code&gt;ChangeIntervalInMinutes&lt;/code&gt;.\nCustom decision
    /// algorithm             can be provided in TiPCallback site extension
    /// which URL can be specified in
    /// &lt;code&gt;ChangeDecisionCallbackUrl&lt;/code&gt;.
    /// </summary>
    public BicepValue<double> ChangeStep 
    {
        get { Initialize(); return _changeStep!; }
        set { Initialize(); _changeStep!.Assign(value); }
    }
    private BicepValue<double>? _changeStep;

    /// <summary>
    /// Specifies interval in minutes to reevaluate ReroutePercentage.
    /// </summary>
    public BicepValue<int> ChangeIntervalInMinutes 
    {
        get { Initialize(); return _changeIntervalInMinutes!; }
        set { Initialize(); _changeIntervalInMinutes!.Assign(value); }
    }
    private BicepValue<int>? _changeIntervalInMinutes;

    /// <summary>
    /// Specifies lower boundary above which ReroutePercentage will stay.
    /// </summary>
    public BicepValue<double> MinReroutePercentage 
    {
        get { Initialize(); return _minReroutePercentage!; }
        set { Initialize(); _minReroutePercentage!.Assign(value); }
    }
    private BicepValue<double>? _minReroutePercentage;

    /// <summary>
    /// Specifies upper boundary below which ReroutePercentage will stay.
    /// </summary>
    public BicepValue<double> MaxReroutePercentage 
    {
        get { Initialize(); return _maxReroutePercentage!; }
        set { Initialize(); _maxReroutePercentage!.Assign(value); }
    }
    private BicepValue<double>? _maxReroutePercentage;

    /// <summary>
    /// Custom decision algorithm can be provided in TiPCallback site extension
    /// which URL can be specified. See TiPCallback site extension for the
    /// scaffold and contracts.
    /// https://www.siteextensions.net/packages/TiPCallback/
    /// </summary>
    public BicepValue<Uri> ChangeDecisionCallbackUri 
    {
        get { Initialize(); return _changeDecisionCallbackUri!; }
        set { Initialize(); _changeDecisionCallbackUri!.Assign(value); }
    }
    private BicepValue<Uri>? _changeDecisionCallbackUri;

    /// <summary>
    /// Name of the routing rule. The recommended name would be to point to the
    /// slot which will receive the traffic in the experiment.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Creates a new RampUpRule.
    /// </summary>
    public RampUpRule()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of RampUpRule.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _actionHostName = DefineProperty<string>("ActionHostName", ["actionHostName"]);
        _reroutePercentage = DefineProperty<double>("ReroutePercentage", ["reroutePercentage"]);
        _changeStep = DefineProperty<double>("ChangeStep", ["changeStep"]);
        _changeIntervalInMinutes = DefineProperty<int>("ChangeIntervalInMinutes", ["changeIntervalInMinutes"]);
        _minReroutePercentage = DefineProperty<double>("MinReroutePercentage", ["minReroutePercentage"]);
        _maxReroutePercentage = DefineProperty<double>("MaxReroutePercentage", ["maxReroutePercentage"]);
        _changeDecisionCallbackUri = DefineProperty<Uri>("ChangeDecisionCallbackUri", ["changeDecisionCallbackUrl"]);
        _name = DefineProperty<string>("Name", ["name"]);
    }
}
