// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The state of a private link connection.
/// </summary>
public partial class PrivateLinkConnectionState : ProvisionableConstruct
{
    /// <summary>
    /// Status of a private link connection.
    /// </summary>
    public BicepValue<string> Status 
    {
        get { Initialize(); return _status!; }
        set { Initialize(); _status!.Assign(value); }
    }
    private BicepValue<string>? _status;

    /// <summary>
    /// Description of a private link connection.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// ActionsRequired for a private link connection.
    /// </summary>
    public BicepValue<string> ActionsRequired 
    {
        get { Initialize(); return _actionsRequired!; }
        set { Initialize(); _actionsRequired!.Assign(value); }
    }
    private BicepValue<string>? _actionsRequired;

    /// <summary>
    /// Creates a new PrivateLinkConnectionState.
    /// </summary>
    public PrivateLinkConnectionState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PrivateLinkConnectionState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _status = DefineProperty<string>("Status", ["status"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _actionsRequired = DefineProperty<string>("ActionsRequired", ["actionsRequired"]);
    }
}
