// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Description of a Virtual Network that is useable for private site access.
/// </summary>
public partial class PrivateAccessVirtualNetwork : ProvisionableConstruct
{
    /// <summary>
    /// The name of the Virtual Network.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The key (ID) of the Virtual Network.
    /// </summary>
    public BicepValue<int> Key 
    {
        get { Initialize(); return _key!; }
        set { Initialize(); _key!.Assign(value); }
    }
    private BicepValue<int>? _key;

    /// <summary>
    /// The ARM uri of the Virtual Network.
    /// </summary>
    public BicepValue<ResourceIdentifier> ResourceId 
    {
        get { Initialize(); return _resourceId!; }
        set { Initialize(); _resourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _resourceId;

    /// <summary>
    /// A List of subnets that access is allowed to on this Virtual Network. An
    /// empty array (but not null) is interpreted to mean that all subnets are
    /// allowed within this Virtual Network.
    /// </summary>
    public BicepList<PrivateAccessSubnet> Subnets 
    {
        get { Initialize(); return _subnets!; }
        set { Initialize(); _subnets!.Assign(value); }
    }
    private BicepList<PrivateAccessSubnet>? _subnets;

    /// <summary>
    /// Creates a new PrivateAccessVirtualNetwork.
    /// </summary>
    public PrivateAccessVirtualNetwork()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PrivateAccessVirtualNetwork.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _key = DefineProperty<int>("Key", ["key"]);
        _resourceId = DefineProperty<ResourceIdentifier>("ResourceId", ["resourceId"]);
        _subnets = DefineListProperty<PrivateAccessSubnet>("Subnets", ["subnets"]);
    }
}
