// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Description of a Virtual Network subnet that is useable for private site
/// access.
/// </summary>
public partial class PrivateAccessSubnet : ProvisionableConstruct
{
    /// <summary>
    /// The name of the subnet.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The key (ID) of the subnet.
    /// </summary>
    public BicepValue<int> Key 
    {
        get { Initialize(); return _key!; }
        set { Initialize(); _key!.Assign(value); }
    }
    private BicepValue<int>? _key;

    /// <summary>
    /// Creates a new PrivateAccessSubnet.
    /// </summary>
    public PrivateAccessSubnet()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of PrivateAccessSubnet.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _key = DefineProperty<int>("Key", ["key"]);
    }
}
