// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The LogAnalyticsConfiguration.
/// </summary>
public partial class LogAnalyticsConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the customer id.
    /// </summary>
    public BicepValue<string> CustomerId 
    {
        get { Initialize(); return _customerId!; }
        set { Initialize(); _customerId!.Assign(value); }
    }
    private BicepValue<string>? _customerId;

    /// <summary>
    /// Gets or sets the shared key.
    /// </summary>
    public BicepValue<string> SharedKey 
    {
        get { Initialize(); return _sharedKey!; }
        set { Initialize(); _sharedKey!.Assign(value); }
    }
    private BicepValue<string>? _sharedKey;

    /// <summary>
    /// Creates a new LogAnalyticsConfiguration.
    /// </summary>
    public LogAnalyticsConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of LogAnalyticsConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _customerId = DefineProperty<string>("CustomerId", ["customerId"]);
        _sharedKey = DefineProperty<string>("SharedKey", ["sharedKey"]);
    }
}
