// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The IIS handler mappings used to define which handler processes HTTP
/// requests with certain extension.             For example, it is used to
/// configure php-cgi.exe process to handle all HTTP requests with *.php
/// extension.
/// </summary>
public partial class HttpRequestHandlerMapping : ProvisionableConstruct
{
    /// <summary>
    /// Requests with this extension will be handled using the specified
    /// FastCGI application.
    /// </summary>
    public BicepValue<string> Extension 
    {
        get { Initialize(); return _extension!; }
        set { Initialize(); _extension!.Assign(value); }
    }
    private BicepValue<string>? _extension;

    /// <summary>
    /// The absolute path to the FastCGI application.
    /// </summary>
    public BicepValue<string> ScriptProcessor 
    {
        get { Initialize(); return _scriptProcessor!; }
        set { Initialize(); _scriptProcessor!.Assign(value); }
    }
    private BicepValue<string>? _scriptProcessor;

    /// <summary>
    /// Command-line arguments to be passed to the script processor.
    /// </summary>
    public BicepValue<string> Arguments 
    {
        get { Initialize(); return _arguments!; }
        set { Initialize(); _arguments!.Assign(value); }
    }
    private BicepValue<string>? _arguments;

    /// <summary>
    /// Creates a new HttpRequestHandlerMapping.
    /// </summary>
    public HttpRequestHandlerMapping()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of HttpRequestHandlerMapping.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _extension = DefineProperty<string>("Extension", ["extension"]);
        _scriptProcessor = DefineProperty<string>("ScriptProcessor", ["scriptProcessor"]);
        _arguments = DefineProperty<string>("Arguments", ["arguments"]);
    }
}
