// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SSL-enabled hostname.
/// </summary>
public partial class HostNameSslState : ProvisionableConstruct
{
    /// <summary>
    /// Hostname.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// SSL type.
    /// </summary>
    public BicepValue<HostNameBindingSslState> SslState 
    {
        get { Initialize(); return _sslState!; }
        set { Initialize(); _sslState!.Assign(value); }
    }
    private BicepValue<HostNameBindingSslState>? _sslState;

    /// <summary>
    /// Virtual IP address assigned to the hostname if IP based SSL is enabled.
    /// </summary>
    public BicepValue<string> VirtualIP 
    {
        get { Initialize(); return _virtualIP!; }
        set { Initialize(); _virtualIP!.Assign(value); }
    }
    private BicepValue<string>? _virtualIP;

    /// <summary>
    /// SSL certificate thumbprint.
    /// </summary>
    public BicepValue<string> ThumbprintString 
    {
        get { Initialize(); return _thumbprintString!; }
        set { Initialize(); _thumbprintString!.Assign(value); }
    }
    private BicepValue<string>? _thumbprintString;

    /// <summary>
    /// Set to &lt;code&gt;true&lt;/code&gt; to update existing hostname.
    /// </summary>
    public BicepValue<bool> ToUpdate 
    {
        get { Initialize(); return _toUpdate!; }
        set { Initialize(); _toUpdate!.Assign(value); }
    }
    private BicepValue<bool>? _toUpdate;

    /// <summary>
    /// Indicates whether the hostname is a standard or repository hostname.
    /// </summary>
    public BicepValue<AppServiceHostType> HostType 
    {
        get { Initialize(); return _hostType!; }
        set { Initialize(); _hostType!.Assign(value); }
    }
    private BicepValue<AppServiceHostType>? _hostType;

    /// <summary>
    /// Creates a new HostNameSslState.
    /// </summary>
    public HostNameSslState()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of HostNameSslState.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _sslState = DefineProperty<HostNameBindingSslState>("SslState", ["sslState"]);
        _virtualIP = DefineProperty<string>("VirtualIP", ["virtualIP"]);
        _thumbprintString = DefineProperty<string>("ThumbprintString", ["thumbprint"]);
        _toUpdate = DefineProperty<bool>("ToUpdate", ["toUpdate"]);
        _hostType = DefineProperty<AppServiceHostType>("HostType", ["hostType"]);
    }
}
