// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The GitHub action container configuration.
/// </summary>
public partial class GitHubActionContainerConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// The server URL for the container registry where the build will be
    /// hosted.
    /// </summary>
    public BicepValue<Uri> ServerUri 
    {
        get { Initialize(); return _serverUri!; }
        set { Initialize(); _serverUri!.Assign(value); }
    }
    private BicepValue<Uri>? _serverUri;

    /// <summary>
    /// The image name for the build.
    /// </summary>
    public BicepValue<string> ImageName 
    {
        get { Initialize(); return _imageName!; }
        set { Initialize(); _imageName!.Assign(value); }
    }
    private BicepValue<string>? _imageName;

    /// <summary>
    /// The username used to upload the image to the container registry.
    /// </summary>
    public BicepValue<string> Username 
    {
        get { Initialize(); return _username!; }
        set { Initialize(); _username!.Assign(value); }
    }
    private BicepValue<string>? _username;

    /// <summary>
    /// The password used to upload the image to the container registry.
    /// </summary>
    public BicepValue<string> Password 
    {
        get { Initialize(); return _password!; }
        set { Initialize(); _password!.Assign(value); }
    }
    private BicepValue<string>? _password;

    /// <summary>
    /// Creates a new GitHubActionContainerConfiguration.
    /// </summary>
    public GitHubActionContainerConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// GitHubActionContainerConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _serverUri = DefineProperty<Uri>("ServerUri", ["serverUrl"]);
        _imageName = DefineProperty<string>("ImageName", ["imageName"]);
        _username = DefineProperty<string>("Username", ["username"]);
        _password = DefineProperty<string>("Password", ["password"]);
    }
}
