// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The GitHub action configuration.
/// </summary>
public partial class GitHubActionConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// GitHub Action code configuration.
    /// </summary>
    public GitHubActionCodeConfiguration CodeConfiguration 
    {
        get { Initialize(); return _codeConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _codeConfiguration, value); }
    }
    private GitHubActionCodeConfiguration? _codeConfiguration;

    /// <summary>
    /// GitHub Action container configuration.
    /// </summary>
    public GitHubActionContainerConfiguration ContainerConfiguration 
    {
        get { Initialize(); return _containerConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _containerConfiguration, value); }
    }
    private GitHubActionContainerConfiguration? _containerConfiguration;

    /// <summary>
    /// This will help determine the workflow configuration to select.
    /// </summary>
    public BicepValue<bool> IsLinux 
    {
        get { Initialize(); return _isLinux!; }
        set { Initialize(); _isLinux!.Assign(value); }
    }
    private BicepValue<bool>? _isLinux;

    /// <summary>
    /// Workflow option to determine whether the workflow file should be
    /// generated and written to the repository.
    /// </summary>
    public BicepValue<bool> GenerateWorkflowFile 
    {
        get { Initialize(); return _generateWorkflowFile!; }
        set { Initialize(); _generateWorkflowFile!.Assign(value); }
    }
    private BicepValue<bool>? _generateWorkflowFile;

    /// <summary>
    /// Creates a new GitHubActionConfiguration.
    /// </summary>
    public GitHubActionConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of GitHubActionConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _codeConfiguration = DefineModelProperty<GitHubActionCodeConfiguration>("CodeConfiguration", ["codeConfiguration"]);
        _containerConfiguration = DefineModelProperty<GitHubActionContainerConfiguration>("ContainerConfiguration", ["containerConfiguration"]);
        _isLinux = DefineProperty<bool>("IsLinux", ["isLinux"]);
        _generateWorkflowFile = DefineProperty<bool>("GenerateWorkflowFile", ["generateWorkflowFile"]);
    }
}
