// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The GitHub action code configuration.
/// </summary>
public partial class GitHubActionCodeConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Runtime stack is used to determine the workflow file content for code
    /// base apps.
    /// </summary>
    public BicepValue<string> RuntimeStack 
    {
        get { Initialize(); return _runtimeStack!; }
        set { Initialize(); _runtimeStack!.Assign(value); }
    }
    private BicepValue<string>? _runtimeStack;

    /// <summary>
    /// Runtime version is used to determine what build version to set in the
    /// workflow file.
    /// </summary>
    public BicepValue<string> RuntimeVersion 
    {
        get { Initialize(); return _runtimeVersion!; }
        set { Initialize(); _runtimeVersion!.Assign(value); }
    }
    private BicepValue<string>? _runtimeVersion;

    /// <summary>
    /// Creates a new GitHubActionCodeConfiguration.
    /// </summary>
    public GitHubActionCodeConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// GitHubActionCodeConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _runtimeStack = DefineProperty<string>("RuntimeStack", ["runtimeStack"]);
        _runtimeVersion = DefineProperty<string>("RuntimeVersion", ["runtimeVersion"]);
    }
}
