// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Authentication method to access the storage account for deployment.
/// </summary>
public partial class FunctionAppStorageAuthentication : ProvisionableConstruct
{
    /// <summary>
    /// Property to select authentication type to access the selected storage
    /// account. Available options: SystemAssignedIdentity,
    /// UserAssignedIdentity, StorageAccountConnectionString.
    /// </summary>
    public BicepValue<FunctionAppStorageAccountAuthenticationType> AuthenticationType 
    {
        get { Initialize(); return _authenticationType!; }
        set { Initialize(); _authenticationType!.Assign(value); }
    }
    private BicepValue<FunctionAppStorageAccountAuthenticationType>? _authenticationType;

    /// <summary>
    /// Use this property for UserAssignedIdentity. Set the resource ID of the
    /// identity. Do not set a value for this property when using other
    /// authentication type.
    /// </summary>
    public BicepValue<string> UserAssignedIdentityResourceId 
    {
        get { Initialize(); return _userAssignedIdentityResourceId!; }
        set { Initialize(); _userAssignedIdentityResourceId!.Assign(value); }
    }
    private BicepValue<string>? _userAssignedIdentityResourceId;

    /// <summary>
    /// Use this property for StorageAccountConnectionString. Set the name of
    /// the app setting that has the storage account connection string. Do not
    /// set a value for this property when using other authentication type.
    /// </summary>
    public BicepValue<string> StorageAccountConnectionStringName 
    {
        get { Initialize(); return _storageAccountConnectionStringName!; }
        set { Initialize(); _storageAccountConnectionStringName!.Assign(value); }
    }
    private BicepValue<string>? _storageAccountConnectionStringName;

    /// <summary>
    /// Creates a new FunctionAppStorageAuthentication.
    /// </summary>
    public FunctionAppStorageAuthentication()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// FunctionAppStorageAuthentication.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _authenticationType = DefineProperty<FunctionAppStorageAccountAuthenticationType>("AuthenticationType", ["type"]);
        _userAssignedIdentityResourceId = DefineProperty<string>("UserAssignedIdentityResourceId", ["userAssignedIdentityResourceId"]);
        _storageAccountConnectionStringName = DefineProperty<string>("StorageAccountConnectionStringName", ["storageAccountConnectionStringName"]);
    }
}
