// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Storage for deployed package used by the function app.
/// </summary>
public partial class FunctionAppStorage : ProvisionableConstruct
{
    /// <summary>
    /// Property to select Azure Storage type. Available options: blobContainer.
    /// </summary>
    public BicepValue<FunctionAppStorageType> StorageType 
    {
        get { Initialize(); return _storageType!; }
        set { Initialize(); _storageType!.Assign(value); }
    }
    private BicepValue<FunctionAppStorageType>? _storageType;

    /// <summary>
    /// Property to set the URL for the selected Azure Storage type. Example:
    /// For blobContainer, the value could be
    /// https://&lt;storageAccountName&gt;.blob.core.windows.net/&lt;containerName&gt;.
    /// </summary>
    public BicepValue<Uri> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<Uri>? _value;

    /// <summary>
    /// Authentication method to access the storage account for deployment.
    /// </summary>
    public FunctionAppStorageAuthentication Authentication 
    {
        get { Initialize(); return _authentication!; }
        set { Initialize(); AssignOrReplace(ref _authentication, value); }
    }
    private FunctionAppStorageAuthentication? _authentication;

    /// <summary>
    /// Creates a new FunctionAppStorage.
    /// </summary>
    public FunctionAppStorage()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FunctionAppStorage.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _storageType = DefineProperty<FunctionAppStorageType>("StorageType", ["type"]);
        _value = DefineProperty<Uri>("Value", ["value"]);
        _authentication = DefineModelProperty<FunctionAppStorageAuthentication>("Authentication", ["authentication"]);
    }
}
