// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Function app runtime name and version.
/// </summary>
public partial class FunctionAppRuntime : ProvisionableConstruct
{
    /// <summary>
    /// Function app runtime name. Available options: dotnet-isolated, node,
    /// java, powershell, python, custom.
    /// </summary>
    public BicepValue<FunctionAppRuntimeName> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<FunctionAppRuntimeName>? _name;

    /// <summary>
    /// Function app runtime version. Example: 8 (for dotnet-isolated).
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
        set { Initialize(); _version!.Assign(value); }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new FunctionAppRuntime.
    /// </summary>
    public FunctionAppRuntime()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FunctionAppRuntime.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<FunctionAppRuntimeName>("Name", ["name"]);
        _version = DefineProperty<string>("Version", ["version"]);
    }
}
