// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Function app resource requirements.
/// </summary>
public partial class FunctionAppResourceConfig : ProvisionableConstruct
{
    /// <summary>
    /// Required CPU in cores, e.g. 0.5.
    /// </summary>
    public BicepValue<double> Cpu 
    {
        get { Initialize(); return _cpu!; }
        set { Initialize(); _cpu!.Assign(value); }
    }
    private BicepValue<double>? _cpu;

    /// <summary>
    /// Required memory, e.g. &quot;1Gi&quot;.
    /// </summary>
    public BicepValue<string> Memory 
    {
        get { Initialize(); return _memory!; }
        set { Initialize(); _memory!.Assign(value); }
    }
    private BicepValue<string>? _memory;

    /// <summary>
    /// Creates a new FunctionAppResourceConfig.
    /// </summary>
    public FunctionAppResourceConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FunctionAppResourceConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _cpu = DefineProperty<double>("Cpu", ["cpu"]);
        _memory = DefineProperty<string>("Memory", ["memory"]);
    }
}
