// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Function app configuration.
/// </summary>
public partial class FunctionAppConfig : ProvisionableConstruct
{
    /// <summary>
    /// Storage for deployed package used by the function app.
    /// </summary>
    public FunctionAppStorage DeploymentStorage 
    {
        get { Initialize(); return _deploymentStorage!; }
        set { Initialize(); AssignOrReplace(ref _deploymentStorage, value); }
    }
    private FunctionAppStorage? _deploymentStorage;

    /// <summary>
    /// Function app runtime settings.
    /// </summary>
    public FunctionAppRuntime Runtime 
    {
        get { Initialize(); return _runtime!; }
        set { Initialize(); AssignOrReplace(ref _runtime, value); }
    }
    private FunctionAppRuntime? _runtime;

    /// <summary>
    /// Function app scale and concurrency settings.
    /// </summary>
    public FunctionAppScaleAndConcurrency ScaleAndConcurrency 
    {
        get { Initialize(); return _scaleAndConcurrency!; }
        set { Initialize(); AssignOrReplace(ref _scaleAndConcurrency, value); }
    }
    private FunctionAppScaleAndConcurrency? _scaleAndConcurrency;

    /// <summary>
    /// Creates a new FunctionAppConfig.
    /// </summary>
    public FunctionAppConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of FunctionAppConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _deploymentStorage = DefineModelProperty<FunctionAppStorage>("DeploymentStorage", ["deployment", "storage"]);
        _runtime = DefineModelProperty<FunctionAppRuntime>("Runtime", ["runtime"]);
        _scaleAndConcurrency = DefineModelProperty<FunctionAppScaleAndConcurrency>("ScaleAndConcurrency", ["scaleAndConcurrency"]);
    }
}
