// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The ContainerAppsConfiguration.
/// </summary>
public partial class ContainerAppsConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Azure Monitor instrumentation key used by Dapr to export Service to
    /// Service communication telemetry.
    /// </summary>
    public BicepValue<string> DaprAIInstrumentationKey 
    {
        get { Initialize(); return _daprAIInstrumentationKey!; }
        set { Initialize(); _daprAIInstrumentationKey!.Assign(value); }
    }
    private BicepValue<string>? _daprAIInstrumentationKey;

    /// <summary>
    /// IP range in CIDR notation that can be reserved for environment
    /// infrastructure IP addresses. It must not overlap with any other Subnet
    /// IP ranges.
    /// </summary>
    public BicepValue<string> PlatformReservedCidr 
    {
        get { Initialize(); return _platformReservedCidr!; }
        set { Initialize(); _platformReservedCidr!.Assign(value); }
    }
    private BicepValue<string>? _platformReservedCidr;

    /// <summary>
    /// An IP address from the IP range defined by platformReservedCidr that
    /// will be reserved for the internal DNS server.
    /// </summary>
    public BicepValue<string> PlatformReservedDnsIP 
    {
        get { Initialize(); return _platformReservedDnsIP!; }
        set { Initialize(); _platformReservedDnsIP!.Assign(value); }
    }
    private BicepValue<string>? _platformReservedDnsIP;

    /// <summary>
    /// Resource ID of a subnet for control plane infrastructure components.
    /// This subnet must be in the same VNET as the subnet defined in
    /// appSubnetResourceId. Must not overlap with the IP range defined in
    /// platformReservedCidr, if defined.
    /// </summary>
    public BicepValue<string> ControlPlaneSubnetResourceId 
    {
        get { Initialize(); return _controlPlaneSubnetResourceId!; }
        set { Initialize(); _controlPlaneSubnetResourceId!.Assign(value); }
    }
    private BicepValue<string>? _controlPlaneSubnetResourceId;

    /// <summary>
    /// Resource ID of a subnet for control plane infrastructure components.
    /// This subnet must be in the same VNET as the subnet defined in
    /// appSubnetResourceId. Must not overlap with the IP range defined in
    /// platformReservedCidr, if defined.
    /// </summary>
    public BicepValue<string> AppSubnetResourceId 
    {
        get { Initialize(); return _appSubnetResourceId!; }
        set { Initialize(); _appSubnetResourceId!.Assign(value); }
    }
    private BicepValue<string>? _appSubnetResourceId;

    /// <summary>
    /// CIDR notation IP range assigned to the Docker bridge network. It must
    /// not overlap with any Subnet IP ranges or the IP range defined in
    /// platformReservedCidr, if defined.
    /// </summary>
    public BicepValue<string> DockerBridgeCidr 
    {
        get { Initialize(); return _dockerBridgeCidr!; }
        set { Initialize(); _dockerBridgeCidr!.Assign(value); }
    }
    private BicepValue<string>? _dockerBridgeCidr;

    /// <summary>
    /// Creates a new ContainerAppsConfiguration.
    /// </summary>
    public ContainerAppsConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ContainerAppsConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _daprAIInstrumentationKey = DefineProperty<string>("DaprAIInstrumentationKey", ["daprAIInstrumentationKey"]);
        _platformReservedCidr = DefineProperty<string>("PlatformReservedCidr", ["platformReservedCidr"]);
        _platformReservedDnsIP = DefineProperty<string>("PlatformReservedDnsIP", ["platformReservedDnsIP"]);
        _controlPlaneSubnetResourceId = DefineProperty<string>("ControlPlaneSubnetResourceId", ["controlPlaneSubnetResourceId"]);
        _appSubnetResourceId = DefineProperty<string>("AppSubnetResourceId", ["appSubnetResourceId"]);
        _dockerBridgeCidr = DefineProperty<string>("DockerBridgeCidr", ["dockerBridgeCidr"]);
    }
}
