// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Database connection string information.
/// </summary>
public partial class ConnStringInfo : ProvisionableConstruct
{
    /// <summary>
    /// Name of connection string.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Connection string value.
    /// </summary>
    public BicepValue<string> ConnectionString 
    {
        get { Initialize(); return _connectionString!; }
        set { Initialize(); _connectionString!.Assign(value); }
    }
    private BicepValue<string>? _connectionString;

    /// <summary>
    /// Type of database.
    /// </summary>
    public BicepValue<ConnectionStringType> ConnectionStringType 
    {
        get { Initialize(); return _connectionStringType!; }
        set { Initialize(); _connectionStringType!.Assign(value); }
    }
    private BicepValue<ConnectionStringType>? _connectionStringType;

    /// <summary>
    /// Creates a new ConnStringInfo.
    /// </summary>
    public ConnStringInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ConnStringInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _connectionString = DefineProperty<string>("ConnectionString", ["connectionString"]);
        _connectionStringType = DefineProperty<ConnectionStringType>("ConnectionStringType", ["type"]);
    }
}
