// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Rules that can be defined for auto-heal.
/// </summary>
public partial class AutoHealRules : ProvisionableConstruct
{
    /// <summary>
    /// Conditions that describe when to execute the auto-heal actions.
    /// </summary>
    public AutoHealTriggers Triggers 
    {
        get { Initialize(); return _triggers!; }
        set { Initialize(); AssignOrReplace(ref _triggers, value); }
    }
    private AutoHealTriggers? _triggers;

    /// <summary>
    /// Actions to be executed when a rule is triggered.
    /// </summary>
    public AutoHealActions Actions 
    {
        get { Initialize(); return _actions!; }
        set { Initialize(); AssignOrReplace(ref _actions, value); }
    }
    private AutoHealActions? _actions;

    /// <summary>
    /// Creates a new AutoHealRules.
    /// </summary>
    public AutoHealRules()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AutoHealRules.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _triggers = DefineModelProperty<AutoHealTriggers>("Triggers", ["triggers"]);
        _actions = DefineModelProperty<AutoHealActions>("Actions", ["actions"]);
    }
}
