// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Actions which to take by the auto-heal module when a rule is triggered.
/// </summary>
public partial class AutoHealActions : ProvisionableConstruct
{
    /// <summary>
    /// Predefined action to be taken.
    /// </summary>
    public BicepValue<AutoHealActionType> ActionType 
    {
        get { Initialize(); return _actionType!; }
        set { Initialize(); _actionType!.Assign(value); }
    }
    private BicepValue<AutoHealActionType>? _actionType;

    /// <summary>
    /// Custom action to be taken.
    /// </summary>
    public AutoHealCustomAction CustomAction 
    {
        get { Initialize(); return _customAction!; }
        set { Initialize(); AssignOrReplace(ref _customAction, value); }
    }
    private AutoHealCustomAction? _customAction;

    /// <summary>
    /// Minimum time the process must execute             before taking the
    /// action
    /// </summary>
    public BicepValue<string> MinProcessExecutionTime 
    {
        get { Initialize(); return _minProcessExecutionTime!; }
        set { Initialize(); _minProcessExecutionTime!.Assign(value); }
    }
    private BicepValue<string>? _minProcessExecutionTime;

    /// <summary>
    /// Creates a new AutoHealActions.
    /// </summary>
    public AutoHealActions()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AutoHealActions.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _actionType = DefineProperty<AutoHealActionType>("ActionType", ["actionType"]);
        _customAction = DefineModelProperty<AutoHealCustomAction>("CustomAction", ["customAction"]);
        _minProcessExecutionTime = DefineProperty<string>("MinProcessExecutionTime", ["minProcessExecutionTime"]);
    }
}
