// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppService;

/// <summary>
/// A class representing the AseV3NetworkingConfiguration data model.
/// Full view of networking configuration for an ASE.
/// </summary>
public partial class AseV3NetworkingConfigurationData : ProvisionableConstruct
{
    /// <summary>
    /// Gets the windows outbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> WindowsOutboundIPAddresses 
    {
        get { Initialize(); return _windowsOutboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _windowsOutboundIPAddresses;

    /// <summary>
    /// Gets the linux outbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> LinuxOutboundIPAddresses 
    {
        get { Initialize(); return _linuxOutboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _linuxOutboundIPAddresses;

    /// <summary>
    /// Gets the external inbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> ExternalInboundIPAddresses 
    {
        get { Initialize(); return _externalInboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _externalInboundIPAddresses;

    /// <summary>
    /// Gets the internal inbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> InternalInboundIPAddresses 
    {
        get { Initialize(); return _internalInboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _internalInboundIPAddresses;

    /// <summary>
    /// Property to enable and disable new private endpoint connection creation
    /// on ASE.
    /// </summary>
    public BicepValue<bool> AllowNewPrivateEndpointConnections 
    {
        get { Initialize(); return _allowNewPrivateEndpointConnections!; }
        set { Initialize(); _allowNewPrivateEndpointConnections!.Assign(value); }
    }
    private BicepValue<bool>? _allowNewPrivateEndpointConnections;

    /// <summary>
    /// Property to enable and disable FTP on ASEV3.
    /// </summary>
    public BicepValue<bool> IsFtpEnabled 
    {
        get { Initialize(); return _isFtpEnabled!; }
        set { Initialize(); _isFtpEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isFtpEnabled;

    /// <summary>
    /// Property to enable and disable Remote Debug on ASEV3.
    /// </summary>
    public BicepValue<bool> IsRemoteDebugEnabled 
    {
        get { Initialize(); return _isRemoteDebugEnabled!; }
        set { Initialize(); _isRemoteDebugEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRemoteDebugEnabled;

    /// <summary>
    /// Customer provided Inbound IP Address. Only able to be set on Ase create.
    /// </summary>
    public BicepValue<string> InboundIPAddressOverride 
    {
        get { Initialize(); return _inboundIPAddressOverride!; }
        set { Initialize(); _inboundIPAddressOverride!.Assign(value); }
    }
    private BicepValue<string>? _inboundIPAddressOverride;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AseV3NetworkingConfigurationData.
    /// </summary>
    public AseV3NetworkingConfigurationData()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AseV3NetworkingConfigurationData.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _windowsOutboundIPAddresses = DefineListProperty<IPAddress>("WindowsOutboundIPAddresses", ["properties", "windowsOutboundIpAddresses"], isOutput: true);
        _linuxOutboundIPAddresses = DefineListProperty<IPAddress>("LinuxOutboundIPAddresses", ["properties", "linuxOutboundIpAddresses"], isOutput: true);
        _externalInboundIPAddresses = DefineListProperty<IPAddress>("ExternalInboundIPAddresses", ["properties", "externalInboundIpAddresses"], isOutput: true);
        _internalInboundIPAddresses = DefineListProperty<IPAddress>("InternalInboundIPAddresses", ["properties", "internalInboundIpAddresses"], isOutput: true);
        _allowNewPrivateEndpointConnections = DefineProperty<bool>("AllowNewPrivateEndpointConnections", ["properties", "allowNewPrivateEndpointConnections"]);
        _isFtpEnabled = DefineProperty<bool>("IsFtpEnabled", ["properties", "ftpEnabled"]);
        _isRemoteDebugEnabled = DefineProperty<bool>("IsRemoteDebugEnabled", ["properties", "remoteDebugEnabled"]);
        _inboundIPAddressOverride = DefineProperty<string>("InboundIPAddressOverride", ["properties", "inboundIpAddressOverride"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }
}
