// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The ArcConfiguration.
/// </summary>
public partial class ArcConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the artifacts storage type.
    /// </summary>
    public BicepValue<ArtifactStorageType> ArtifactsStorageType 
    {
        get { Initialize(); return _artifactsStorageType!; }
        set { Initialize(); _artifactsStorageType!.Assign(value); }
    }
    private BicepValue<ArtifactStorageType>? _artifactsStorageType;

    /// <summary>
    /// Gets or sets the artifact storage class name.
    /// </summary>
    public BicepValue<string> ArtifactStorageClassName 
    {
        get { Initialize(); return _artifactStorageClassName!; }
        set { Initialize(); _artifactStorageClassName!.Assign(value); }
    }
    private BicepValue<string>? _artifactStorageClassName;

    /// <summary>
    /// Gets or sets the artifact storage mount path.
    /// </summary>
    public BicepValue<string> ArtifactStorageMountPath 
    {
        get { Initialize(); return _artifactStorageMountPath!; }
        set { Initialize(); _artifactStorageMountPath!.Assign(value); }
    }
    private BicepValue<string>? _artifactStorageMountPath;

    /// <summary>
    /// Gets or sets the artifact storage node name.
    /// </summary>
    public BicepValue<string> ArtifactStorageNodeName 
    {
        get { Initialize(); return _artifactStorageNodeName!; }
        set { Initialize(); _artifactStorageNodeName!.Assign(value); }
    }
    private BicepValue<string>? _artifactStorageNodeName;

    /// <summary>
    /// Gets or sets the artifact storage access mode.
    /// </summary>
    public BicepValue<string> ArtifactStorageAccessMode 
    {
        get { Initialize(); return _artifactStorageAccessMode!; }
        set { Initialize(); _artifactStorageAccessMode!.Assign(value); }
    }
    private BicepValue<string>? _artifactStorageAccessMode;

    /// <summary>
    /// Gets or sets the front end service kind.
    /// </summary>
    public BicepValue<FrontEndServiceType> FrontEndServiceKind 
    {
        get { Initialize(); return _frontEndServiceKind!; }
        set { Initialize(); _frontEndServiceKind!.Assign(value); }
    }
    private BicepValue<FrontEndServiceType>? _frontEndServiceKind;

    /// <summary>
    /// Gets or sets the kube config.
    /// </summary>
    public BicepValue<string> KubeConfig 
    {
        get { Initialize(); return _kubeConfig!; }
        set { Initialize(); _kubeConfig!.Assign(value); }
    }
    private BicepValue<string>? _kubeConfig;

    /// <summary>
    /// Creates a new ArcConfiguration.
    /// </summary>
    public ArcConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ArcConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _artifactsStorageType = DefineProperty<ArtifactStorageType>("ArtifactsStorageType", ["artifactsStorageType"]);
        _artifactStorageClassName = DefineProperty<string>("ArtifactStorageClassName", ["artifactStorageClassName"]);
        _artifactStorageMountPath = DefineProperty<string>("ArtifactStorageMountPath", ["artifactStorageMountPath"]);
        _artifactStorageNodeName = DefineProperty<string>("ArtifactStorageNodeName", ["artifactStorageNodeName"]);
        _artifactStorageAccessMode = DefineProperty<string>("ArtifactStorageAccessMode", ["artifactStorageAccessMode"]);
        _frontEndServiceKind = DefineProperty<FrontEndServiceType>("FrontEndServiceKind", ["frontEndServiceConfiguration", "kind"]);
        _kubeConfig = DefineProperty<string>("KubeConfig", ["kubeConfig"]);
    }
}
