// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Application logs configuration.
/// </summary>
public partial class ApplicationLogsConfig : ProvisionableConstruct
{
    /// <summary>
    /// Log level.
    /// </summary>
    public BicepValue<WebAppLogLevel> FileSystemLevel 
    {
        get { Initialize(); return _fileSystemLevel!; }
        set { Initialize(); _fileSystemLevel!.Assign(value); }
    }
    private BicepValue<WebAppLogLevel>? _fileSystemLevel;

    /// <summary>
    /// Application logs to azure table storage configuration.
    /// </summary>
    public AppServiceTableStorageApplicationLogsConfig AzureTableStorage 
    {
        get { Initialize(); return _azureTableStorage!; }
        set { Initialize(); AssignOrReplace(ref _azureTableStorage, value); }
    }
    private AppServiceTableStorageApplicationLogsConfig? _azureTableStorage;

    /// <summary>
    /// Application logs to blob storage configuration.
    /// </summary>
    public AppServiceBlobStorageApplicationLogsConfig AzureBlobStorage 
    {
        get { Initialize(); return _azureBlobStorage!; }
        set { Initialize(); AssignOrReplace(ref _azureBlobStorage, value); }
    }
    private AppServiceBlobStorageApplicationLogsConfig? _azureBlobStorage;

    /// <summary>
    /// Creates a new ApplicationLogsConfig.
    /// </summary>
    public ApplicationLogsConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of ApplicationLogsConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _fileSystemLevel = DefineProperty<WebAppLogLevel>("FileSystemLevel", ["fileSystem", "level"]);
        _azureTableStorage = DefineModelProperty<AppServiceTableStorageApplicationLogsConfig>("AzureTableStorage", ["azureTableStorage"]);
        _azureBlobStorage = DefineModelProperty<AppServiceBlobStorageApplicationLogsConfig>("AzureBlobStorage", ["azureBlobStorage"]);
    }
}
