// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Specification for using a Virtual Network.
/// </summary>
public partial class AppServiceVirtualNetworkProfile : ProvisionableConstruct
{
    /// <summary>
    /// Resource id of the Virtual Network.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
        set { Initialize(); _id!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Name of the Virtual Network (read-only).
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Resource type of the Virtual Network (read-only).
    /// </summary>
    public BicepValue<ResourceType> ResourceType 
    {
        get { Initialize(); return _resourceType!; }
    }
    private BicepValue<ResourceType>? _resourceType;

    /// <summary>
    /// Subnet within the Virtual Network.
    /// </summary>
    public BicepValue<string> Subnet 
    {
        get { Initialize(); return _subnet!; }
        set { Initialize(); _subnet!.Assign(value); }
    }
    private BicepValue<string>? _subnet;

    /// <summary>
    /// Creates a new AppServiceVirtualNetworkProfile.
    /// </summary>
    public AppServiceVirtualNetworkProfile()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppServiceVirtualNetworkProfile.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"]);
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _resourceType = DefineProperty<ResourceType>("ResourceType", ["type"], isOutput: true);
        _subnet = DefineProperty<string>("Subnet", ["subnet"]);
    }
}
