// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

using System.Runtime.Serialization;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The minimum strength TLS cipher suite allowed for an application.
/// </summary>
public enum AppServiceTlsCipherSuite
{
    /// <summary>
    /// TLS_AES_256_GCM_SHA384.
    /// </summary>
    [DataMember(Name = "TLS_AES_256_GCM_SHA384")]
    TlsAes256GcmSha384,

    /// <summary>
    /// TLS_AES_128_GCM_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_AES_128_GCM_SHA256")]
    TlsAes128GcmSha256,

    /// <summary>
    /// TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384")]
    TlsECDiffieHellmanECDsaWithAes256GcmSha384,

    /// <summary>
    /// TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256")]
    TlsECDiffieHellmanECDsaWithAes128CbcSha256,

    /// <summary>
    /// TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256")]
    TlsECDiffieHellmanECDsaWithAes128GcmSha256,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384")]
    TlsECDiffieHellmanRsaWithAes256GcmSha384,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")]
    TlsECDiffieHellmanRsaWithAes128GcmSha256,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384")]
    TlsECDiffieHellmanRsaWithAes256CbcSha384,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256")]
    TlsECDiffieHellmanRsaWithAes128CbcSha256,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA")]
    TlsECDiffieHellmanRsaWithAes256CbcSha,

    /// <summary>
    /// TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA.
    /// </summary>
    [DataMember(Name = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA")]
    TlsECDiffieHellmanRsaWithAes128CbcSha,

    /// <summary>
    /// TLS_RSA_WITH_AES_256_GCM_SHA384.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_256_GCM_SHA384")]
    TlsRsaWithAes256GcmSha384,

    /// <summary>
    /// TLS_RSA_WITH_AES_128_GCM_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_128_GCM_SHA256")]
    TlsRsaWithAes128GcmSha256,

    /// <summary>
    /// TLS_RSA_WITH_AES_256_CBC_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_256_CBC_SHA256")]
    TlsRsaWithAes256CbcSha256,

    /// <summary>
    /// TLS_RSA_WITH_AES_128_CBC_SHA256.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_128_CBC_SHA256")]
    TlsRsaWithAes128CbcSha256,

    /// <summary>
    /// TLS_RSA_WITH_AES_256_CBC_SHA.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_256_CBC_SHA")]
    TlsRsaWithAes256CbcSha,

    /// <summary>
    /// TLS_RSA_WITH_AES_128_CBC_SHA.
    /// </summary>
    [DataMember(Name = "TLS_RSA_WITH_AES_128_CBC_SHA")]
    TlsRsaWithAes128CbcSha,
}
