// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Application logs to Azure table storage configuration.
/// </summary>
public partial class AppServiceTableStorageApplicationLogsConfig : ProvisionableConstruct
{
    /// <summary>
    /// Log level.
    /// </summary>
    public BicepValue<WebAppLogLevel> Level 
    {
        get { Initialize(); return _level!; }
        set { Initialize(); _level!.Assign(value); }
    }
    private BicepValue<WebAppLogLevel>? _level;

    /// <summary>
    /// SAS URL to an Azure table with add/query/delete permissions.
    /// </summary>
    public BicepValue<string> SasUriString 
    {
        get { Initialize(); return _sasUriString!; }
        set { Initialize(); _sasUriString!.Assign(value); }
    }
    private BicepValue<string>? _sasUriString;

    /// <summary>
    /// Creates a new AppServiceTableStorageApplicationLogsConfig.
    /// </summary>
    public AppServiceTableStorageApplicationLogsConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppServiceTableStorageApplicationLogsConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _level = DefineProperty<WebAppLogLevel>("Level", ["level"]);
        _sasUriString = DefineProperty<string>("SasUriString", ["sasUrl"]);
    }
}
