// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Azure Files or Blob Storage access information value for dictionary storage.
/// </summary>
public partial class AppServiceStorageAccessInfo : ProvisionableConstruct
{
    /// <summary>
    /// Type of storage.
    /// </summary>
    public BicepValue<AppServiceStorageType> StorageType 
    {
        get { Initialize(); return _storageType!; }
        set { Initialize(); _storageType!.Assign(value); }
    }
    private BicepValue<AppServiceStorageType>? _storageType;

    /// <summary>
    /// Name of the storage account.
    /// </summary>
    public BicepValue<string> AccountName 
    {
        get { Initialize(); return _accountName!; }
        set { Initialize(); _accountName!.Assign(value); }
    }
    private BicepValue<string>? _accountName;

    /// <summary>
    /// Name of the file share (container name, for Blob storage).
    /// </summary>
    public BicepValue<string> ShareName 
    {
        get { Initialize(); return _shareName!; }
        set { Initialize(); _shareName!.Assign(value); }
    }
    private BicepValue<string>? _shareName;

    /// <summary>
    /// Access key for the storage account.
    /// </summary>
    public BicepValue<string> AccessKey 
    {
        get { Initialize(); return _accessKey!; }
        set { Initialize(); _accessKey!.Assign(value); }
    }
    private BicepValue<string>? _accessKey;

    /// <summary>
    /// Path to mount the storage within the site&apos;s runtime environment.
    /// </summary>
    public BicepValue<string> MountPath 
    {
        get { Initialize(); return _mountPath!; }
        set { Initialize(); _mountPath!.Assign(value); }
    }
    private BicepValue<string>? _mountPath;

    /// <summary>
    /// State of the storage account.
    /// </summary>
    public BicepValue<AppServiceStorageAccountState> State 
    {
        get { Initialize(); return _state!; }
    }
    private BicepValue<AppServiceStorageAccountState>? _state;

    /// <summary>
    /// Mounting protocol to use for the storage account.
    /// </summary>
    public BicepValue<AppServiceStorageProtocol> Protocol 
    {
        get { Initialize(); return _protocol!; }
        set { Initialize(); _protocol!.Assign(value); }
    }
    private BicepValue<AppServiceStorageProtocol>? _protocol;

    /// <summary>
    /// Creates a new AppServiceStorageAccessInfo.
    /// </summary>
    public AppServiceStorageAccessInfo()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceStorageAccessInfo.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _storageType = DefineProperty<AppServiceStorageType>("StorageType", ["type"]);
        _accountName = DefineProperty<string>("AccountName", ["accountName"]);
        _shareName = DefineProperty<string>("ShareName", ["shareName"]);
        _accessKey = DefineProperty<string>("AccessKey", ["accessKey"]);
        _mountPath = DefineProperty<string>("MountPath", ["mountPath"]);
        _state = DefineProperty<AppServiceStorageAccountState>("State", ["state"], isOutput: true);
        _protocol = DefineProperty<AppServiceStorageProtocol>("Protocol", ["protocol"]);
    }
}
