// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Description of a SKU for a scalable resource.
/// </summary>
public partial class AppServiceSkuDescription : ProvisionableConstruct
{
    /// <summary>
    /// Name of the resource SKU.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Service tier of the resource SKU.
    /// </summary>
    public BicepValue<string> Tier 
    {
        get { Initialize(); return _tier!; }
        set { Initialize(); _tier!.Assign(value); }
    }
    private BicepValue<string>? _tier;

    /// <summary>
    /// Size specifier of the resource SKU.
    /// </summary>
    public BicepValue<string> Size 
    {
        get { Initialize(); return _size!; }
        set { Initialize(); _size!.Assign(value); }
    }
    private BicepValue<string>? _size;

    /// <summary>
    /// Family code of the resource SKU.
    /// </summary>
    public BicepValue<string> Family 
    {
        get { Initialize(); return _family!; }
        set { Initialize(); _family!.Assign(value); }
    }
    private BicepValue<string>? _family;

    /// <summary>
    /// Current number of instances assigned to the resource.
    /// </summary>
    public BicepValue<int> Capacity 
    {
        get { Initialize(); return _capacity!; }
        set { Initialize(); _capacity!.Assign(value); }
    }
    private BicepValue<int>? _capacity;

    /// <summary>
    /// Min, max, and default scale values of the SKU.
    /// </summary>
    public AppServiceSkuCapacity SkuCapacity 
    {
        get { Initialize(); return _skuCapacity!; }
        set { Initialize(); AssignOrReplace(ref _skuCapacity, value); }
    }
    private AppServiceSkuCapacity? _skuCapacity;

    /// <summary>
    /// Locations of the SKU.
    /// </summary>
    public BicepList<AzureLocation> Locations 
    {
        get { Initialize(); return _locations!; }
        set { Initialize(); _locations!.Assign(value); }
    }
    private BicepList<AzureLocation>? _locations;

    /// <summary>
    /// Capabilities of the SKU, e.g., is traffic manager enabled?.
    /// </summary>
    public BicepList<AppServiceSkuCapability> Capabilities 
    {
        get { Initialize(); return _capabilities!; }
        set { Initialize(); _capabilities!.Assign(value); }
    }
    private BicepList<AppServiceSkuCapability>? _capabilities;

    /// <summary>
    /// Creates a new AppServiceSkuDescription.
    /// </summary>
    public AppServiceSkuDescription()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceSkuDescription.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _tier = DefineProperty<string>("Tier", ["tier"]);
        _size = DefineProperty<string>("Size", ["size"]);
        _family = DefineProperty<string>("Family", ["family"]);
        _capacity = DefineProperty<int>("Capacity", ["capacity"]);
        _skuCapacity = DefineModelProperty<AppServiceSkuCapacity>("SkuCapacity", ["skuCapacity"]);
        _locations = DefineListProperty<AzureLocation>("Locations", ["locations"]);
        _capabilities = DefineListProperty<AppServiceSkuCapability>("Capabilities", ["capabilities"]);
    }
}
