// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Description of the App Service plan scale options.
/// </summary>
public partial class AppServiceSkuCapacity : ProvisionableConstruct
{
    /// <summary>
    /// Minimum number of workers for this App Service plan SKU.
    /// </summary>
    public BicepValue<int> Minimum 
    {
        get { Initialize(); return _minimum!; }
        set { Initialize(); _minimum!.Assign(value); }
    }
    private BicepValue<int>? _minimum;

    /// <summary>
    /// Maximum number of workers for this App Service plan SKU.
    /// </summary>
    public BicepValue<int> Maximum 
    {
        get { Initialize(); return _maximum!; }
        set { Initialize(); _maximum!.Assign(value); }
    }
    private BicepValue<int>? _maximum;

    /// <summary>
    /// Maximum number of Elastic workers for this App Service plan SKU.
    /// </summary>
    public BicepValue<int> ElasticMaximum 
    {
        get { Initialize(); return _elasticMaximum!; }
        set { Initialize(); _elasticMaximum!.Assign(value); }
    }
    private BicepValue<int>? _elasticMaximum;

    /// <summary>
    /// Default number of workers for this App Service plan SKU.
    /// </summary>
    public BicepValue<int> Default 
    {
        get { Initialize(); return _default!; }
        set { Initialize(); _default!.Assign(value); }
    }
    private BicepValue<int>? _default;

    /// <summary>
    /// Available scale configurations for an App Service plan.
    /// </summary>
    public BicepValue<string> ScaleType 
    {
        get { Initialize(); return _scaleType!; }
        set { Initialize(); _scaleType!.Assign(value); }
    }
    private BicepValue<string>? _scaleType;

    /// <summary>
    /// Creates a new AppServiceSkuCapacity.
    /// </summary>
    public AppServiceSkuCapacity()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceSkuCapacity.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _minimum = DefineProperty<int>("Minimum", ["minimum"]);
        _maximum = DefineProperty<int>("Maximum", ["maximum"]);
        _elasticMaximum = DefineProperty<int>("ElasticMaximum", ["elasticMaximum"]);
        _default = DefineProperty<int>("Default", ["default"]);
        _scaleType = DefineProperty<string>("ScaleType", ["scaleType"]);
    }
}
