// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Name value pair.
/// </summary>
public partial class AppServiceNameValuePair : ProvisionableConstruct
{
    /// <summary>
    /// Pair name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Pair value.
    /// </summary>
    public BicepValue<string> Value 
    {
        get { Initialize(); return _value!; }
        set { Initialize(); _value!.Assign(value); }
    }
    private BicepValue<string>? _value;

    /// <summary>
    /// Creates a new AppServiceNameValuePair.
    /// </summary>
    public AppServiceNameValuePair()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceNameValuePair.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"]);
        _value = DefineProperty<string>("Value", ["value"]);
    }
}
