// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// IP security restriction on an app.
/// </summary>
public partial class AppServiceIPSecurityRestriction : ProvisionableConstruct
{
    /// <summary>
    /// IP address the security restriction is valid for.             It can be
    /// in form of pure ipv4 address (required SubnetMask property) or
    /// CIDR notation such as ipv4/mask (leading bit match). For
    /// CIDR,             SubnetMask property must not be specified.
    /// </summary>
    public BicepValue<string> IPAddressOrCidr 
    {
        get { Initialize(); return _iPAddressOrCidr!; }
        set { Initialize(); _iPAddressOrCidr!.Assign(value); }
    }
    private BicepValue<string>? _iPAddressOrCidr;

    /// <summary>
    /// Subnet mask for the range of IP addresses the restriction is valid for.
    /// </summary>
    public BicepValue<string> SubnetMask 
    {
        get { Initialize(); return _subnetMask!; }
        set { Initialize(); _subnetMask!.Assign(value); }
    }
    private BicepValue<string>? _subnetMask;

    /// <summary>
    /// Virtual network resource id.
    /// </summary>
    public BicepValue<ResourceIdentifier> VnetSubnetResourceId 
    {
        get { Initialize(); return _vnetSubnetResourceId!; }
        set { Initialize(); _vnetSubnetResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _vnetSubnetResourceId;

    /// <summary>
    /// (internal) Vnet traffic tag.
    /// </summary>
    public BicepValue<int> VnetTrafficTag 
    {
        get { Initialize(); return _vnetTrafficTag!; }
        set { Initialize(); _vnetTrafficTag!.Assign(value); }
    }
    private BicepValue<int>? _vnetTrafficTag;

    /// <summary>
    /// (internal) Subnet traffic tag.
    /// </summary>
    public BicepValue<int> SubnetTrafficTag 
    {
        get { Initialize(); return _subnetTrafficTag!; }
        set { Initialize(); _subnetTrafficTag!.Assign(value); }
    }
    private BicepValue<int>? _subnetTrafficTag;

    /// <summary>
    /// Allow or Deny access for this IP range.
    /// </summary>
    public BicepValue<string> Action 
    {
        get { Initialize(); return _action!; }
        set { Initialize(); _action!.Assign(value); }
    }
    private BicepValue<string>? _action;

    /// <summary>
    /// Defines what this IP filter will be used for. This is to support IP
    /// filtering on proxies.
    /// </summary>
    public BicepValue<AppServiceIPFilterTag> Tag 
    {
        get { Initialize(); return _tag!; }
        set { Initialize(); _tag!.Assign(value); }
    }
    private BicepValue<AppServiceIPFilterTag>? _tag;

    /// <summary>
    /// Priority of IP restriction rule.
    /// </summary>
    public BicepValue<int> Priority 
    {
        get { Initialize(); return _priority!; }
        set { Initialize(); _priority!.Assign(value); }
    }
    private BicepValue<int>? _priority;

    /// <summary>
    /// IP restriction rule name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// IP restriction rule description.
    /// </summary>
    public BicepValue<string> Description 
    {
        get { Initialize(); return _description!; }
        set { Initialize(); _description!.Assign(value); }
    }
    private BicepValue<string>? _description;

    /// <summary>
    /// IP restriction rule headers.              X-Forwarded-Host
    /// (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-Host#Examples).
    /// The matching logic is ..              - If the property
    /// is null or empty (default), all hosts(or lack of) are allowed.
    /// - A value is compared using ordinal-ignore-case
    /// (excluding port number).              - Subdomain wildcards are
    /// permitted but don&apos;t match the root domain. For example,
    /// *.contoso.com matches the subdomain foo.contoso.com               but
    /// not the root domain contoso.com or multi-level foo.bar.contoso.com
    /// - Unicode host names are allowed but are converted to
    /// Punycode for matching.                           X-Forwarded-For
    /// (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/X-Forwarded-For#Examples).
    /// The matching logic is ..              - If the property
    /// is null or empty (default), any forwarded-for chains (or lack of) are
    /// allowed.              - If any address (excluding port number) in the
    /// chain (comma separated) matches the CIDR defined by the property.
    /// X-Azure-FDID and X-FD-HealthProbe.
    /// The matching logic is exact match.
    /// </summary>
    public BicepDictionary<BicepList<string>> Headers 
    {
        get { Initialize(); return _headers!; }
        set { Initialize(); _headers!.Assign(value); }
    }
    private BicepDictionary<BicepList<string>>? _headers;

    /// <summary>
    /// Creates a new AppServiceIPSecurityRestriction.
    /// </summary>
    public AppServiceIPSecurityRestriction()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppServiceIPSecurityRestriction.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _iPAddressOrCidr = DefineProperty<string>("IPAddressOrCidr", ["ipAddress"]);
        _subnetMask = DefineProperty<string>("SubnetMask", ["subnetMask"]);
        _vnetSubnetResourceId = DefineProperty<ResourceIdentifier>("VnetSubnetResourceId", ["vnetSubnetResourceId"]);
        _vnetTrafficTag = DefineProperty<int>("VnetTrafficTag", ["vnetTrafficTag"]);
        _subnetTrafficTag = DefineProperty<int>("SubnetTrafficTag", ["subnetTrafficTag"]);
        _action = DefineProperty<string>("Action", ["action"]);
        _tag = DefineProperty<AppServiceIPFilterTag>("Tag", ["tag"]);
        _priority = DefineProperty<int>("Priority", ["priority"]);
        _name = DefineProperty<string>("Name", ["name"]);
        _description = DefineProperty<string>("Description", ["description"]);
        _headers = DefineDictionaryProperty<BicepList<string>>("Headers", ["headers"]);
    }
}
