// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Http logs configuration.
/// </summary>
public partial class AppServiceHttpLogsConfig : ProvisionableConstruct
{
    /// <summary>
    /// Http logs to file system configuration.
    /// </summary>
    public FileSystemHttpLogsConfig FileSystem 
    {
        get { Initialize(); return _fileSystem!; }
        set { Initialize(); AssignOrReplace(ref _fileSystem, value); }
    }
    private FileSystemHttpLogsConfig? _fileSystem;

    /// <summary>
    /// Http logs to azure blob storage configuration.
    /// </summary>
    public AppServiceBlobStorageHttpLogsConfig AzureBlobStorage 
    {
        get { Initialize(); return _azureBlobStorage!; }
        set { Initialize(); AssignOrReplace(ref _azureBlobStorage, value); }
    }
    private AppServiceBlobStorageHttpLogsConfig? _azureBlobStorage;

    /// <summary>
    /// Creates a new AppServiceHttpLogsConfig.
    /// </summary>
    public AppServiceHttpLogsConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceHttpLogsConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _fileSystem = DefineModelProperty<FileSystemHttpLogsConfig>("FileSystem", ["fileSystem"]);
        _azureBlobStorage = DefineModelProperty<AppServiceBlobStorageHttpLogsConfig>("AzureBlobStorage", ["azureBlobStorage"]);
    }
}
