// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

namespace Azure.Provisioning.AppService;

/// <summary>
/// Upgrade Preference.
/// </summary>
public enum AppServiceEnvironmentUpgradePreference
{
    /// <summary>
    /// No preference on when this App Service Environment will be upgraded.
    /// </summary>
    None,

    /// <summary>
    /// This App Service Environment will be upgraded before others in the same
    /// region that have Upgrade Preference &apos;Late&apos;.
    /// </summary>
    Early,

    /// <summary>
    /// This App Service Environment will be upgraded after others in the same
    /// region that have Upgrade Preference &apos;Early&apos;.
    /// </summary>
    Late,

    /// <summary>
    /// ASEv3 only. Once an upgrade is available, this App Service Environment
    /// will wait 10 days for the upgrade to be manually initiated. After 10
    /// days the upgrade will begin automatically.
    /// </summary>
    Manual,
}
