// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Cross-Origin Resource Sharing (CORS) settings for the app.
/// </summary>
public partial class AppServiceCorsSettings : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the list of origins that should be allowed to make
    /// cross-origin             calls (for example:
    /// http://example.com:12345). Use &quot;*&quot; to allow all.
    /// </summary>
    public BicepList<string> AllowedOrigins 
    {
        get { Initialize(); return _allowedOrigins!; }
        set { Initialize(); _allowedOrigins!.Assign(value); }
    }
    private BicepList<string>? _allowedOrigins;

    /// <summary>
    /// Gets or sets whether CORS requests with credentials are allowed. See
    /// https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Requests_with_credentials
    /// for more details.
    /// </summary>
    public BicepValue<bool> IsCredentialsSupported 
    {
        get { Initialize(); return _isCredentialsSupported!; }
        set { Initialize(); _isCredentialsSupported!.Assign(value); }
    }
    private BicepValue<bool>? _isCredentialsSupported;

    /// <summary>
    /// Creates a new AppServiceCorsSettings.
    /// </summary>
    public AppServiceCorsSettings()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceCorsSettings.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _allowedOrigins = DefineListProperty<string>("AllowedOrigins", ["allowedOrigins"]);
        _isCredentialsSupported = DefineProperty<bool>("IsCredentialsSupported", ["supportCredentials"]);
    }
}
