// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// SSL certificate details.
/// </summary>
public partial class AppServiceCertificateDetails : ProvisionableConstruct
{
    /// <summary>
    /// Certificate Version.
    /// </summary>
    public BicepValue<int> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<int>? _version;

    /// <summary>
    /// Certificate Serial Number.
    /// </summary>
    public BicepValue<string> SerialNumber 
    {
        get { Initialize(); return _serialNumber!; }
    }
    private BicepValue<string>? _serialNumber;

    /// <summary>
    /// Certificate Thumbprint.
    /// </summary>
    public BicepValue<string> ThumbprintString 
    {
        get { Initialize(); return _thumbprintString!; }
    }
    private BicepValue<string>? _thumbprintString;

    /// <summary>
    /// Certificate Subject.
    /// </summary>
    public BicepValue<string> Subject 
    {
        get { Initialize(); return _subject!; }
    }
    private BicepValue<string>? _subject;

    /// <summary>
    /// Date Certificate is valid from.
    /// </summary>
    public BicepValue<DateTimeOffset> NotBefore 
    {
        get { Initialize(); return _notBefore!; }
    }
    private BicepValue<DateTimeOffset>? _notBefore;

    /// <summary>
    /// Date Certificate is valid to.
    /// </summary>
    public BicepValue<DateTimeOffset> NotAfter 
    {
        get { Initialize(); return _notAfter!; }
    }
    private BicepValue<DateTimeOffset>? _notAfter;

    /// <summary>
    /// Certificate Signature algorithm.
    /// </summary>
    public BicepValue<string> SignatureAlgorithm 
    {
        get { Initialize(); return _signatureAlgorithm!; }
    }
    private BicepValue<string>? _signatureAlgorithm;

    /// <summary>
    /// Certificate Issuer.
    /// </summary>
    public BicepValue<string> Issuer 
    {
        get { Initialize(); return _issuer!; }
    }
    private BicepValue<string>? _issuer;

    /// <summary>
    /// Raw certificate data.
    /// </summary>
    public BicepValue<string> RawData 
    {
        get { Initialize(); return _rawData!; }
    }
    private BicepValue<string>? _rawData;

    /// <summary>
    /// Creates a new AppServiceCertificateDetails.
    /// </summary>
    public AppServiceCertificateDetails()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceCertificateDetails.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _version = DefineProperty<int>("Version", ["version"], isOutput: true);
        _serialNumber = DefineProperty<string>("SerialNumber", ["serialNumber"], isOutput: true);
        _thumbprintString = DefineProperty<string>("ThumbprintString", ["thumbprint"], isOutput: true);
        _subject = DefineProperty<string>("Subject", ["subject"], isOutput: true);
        _notBefore = DefineProperty<DateTimeOffset>("NotBefore", ["notBefore"], isOutput: true);
        _notAfter = DefineProperty<DateTimeOffset>("NotAfter", ["notAfter"], isOutput: true);
        _signatureAlgorithm = DefineProperty<string>("SignatureAlgorithm", ["signatureAlgorithm"], isOutput: true);
        _issuer = DefineProperty<string>("Issuer", ["issuer"], isOutput: true);
        _rawData = DefineProperty<string>("RawData", ["rawData"], isOutput: true);
    }
}
