// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// Http logs to azure blob storage configuration.
/// </summary>
public partial class AppServiceBlobStorageHttpLogsConfig : ProvisionableConstruct
{
    /// <summary>
    /// SAS url to a azure blob container with read/write/list/delete
    /// permissions.
    /// </summary>
    public BicepValue<Uri> SasUri 
    {
        get { Initialize(); return _sasUri!; }
        set { Initialize(); _sasUri!.Assign(value); }
    }
    private BicepValue<Uri>? _sasUri;

    /// <summary>
    /// Retention in days.             Remove blobs older than X days.
    /// 0 or lower means no retention.
    /// </summary>
    public BicepValue<int> RetentionInDays 
    {
        get { Initialize(); return _retentionInDays!; }
        set { Initialize(); _retentionInDays!.Assign(value); }
    }
    private BicepValue<int>? _retentionInDays;

    /// <summary>
    /// True if configuration is enabled, false if it is disabled and null if
    /// configuration is not set.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Creates a new AppServiceBlobStorageHttpLogsConfig.
    /// </summary>
    public AppServiceBlobStorageHttpLogsConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppServiceBlobStorageHttpLogsConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _sasUri = DefineProperty<Uri>("SasUri", ["sasUrl"]);
        _retentionInDays = DefineProperty<int>("RetentionInDays", ["retentionInDays"]);
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
    }
}
