// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The plan object in Azure Resource Manager, represents a marketplace plan.
/// </summary>
public partial class AppServiceArmPlan : ProvisionableConstruct
{
    /// <summary>
    /// The name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// The publisher.
    /// </summary>
    public BicepValue<string> Publisher 
    {
        get { Initialize(); return _publisher!; }
    }
    private BicepValue<string>? _publisher;

    /// <summary>
    /// The product.
    /// </summary>
    public BicepValue<string> Product 
    {
        get { Initialize(); return _product!; }
    }
    private BicepValue<string>? _product;

    /// <summary>
    /// The promotion code.
    /// </summary>
    public BicepValue<string> PromotionCode 
    {
        get { Initialize(); return _promotionCode!; }
    }
    private BicepValue<string>? _promotionCode;

    /// <summary>
    /// Version of product.
    /// </summary>
    public BicepValue<string> Version 
    {
        get { Initialize(); return _version!; }
    }
    private BicepValue<string>? _version;

    /// <summary>
    /// Creates a new AppServiceArmPlan.
    /// </summary>
    public AppServiceArmPlan()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServiceArmPlan.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _publisher = DefineProperty<string>("Publisher", ["publisher"], isOutput: true);
        _product = DefineProperty<string>("Product", ["product"], isOutput: true);
        _promotionCode = DefineProperty<string>("PromotionCode", ["promotionCode"], isOutput: true);
        _version = DefineProperty<string>("Version", ["version"], isOutput: true);
    }
}
