// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// The AppLogsConfiguration.
/// </summary>
public partial class AppLogsConfiguration : ProvisionableConstruct
{
    /// <summary>
    /// Gets or sets the destination.
    /// </summary>
    public BicepValue<string> Destination 
    {
        get { Initialize(); return _destination!; }
        set { Initialize(); _destination!.Assign(value); }
    }
    private BicepValue<string>? _destination;

    /// <summary>
    /// Gets or sets the log analytics configuration.
    /// </summary>
    public LogAnalyticsConfiguration LogAnalyticsConfiguration 
    {
        get { Initialize(); return _logAnalyticsConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _logAnalyticsConfiguration, value); }
    }
    private LogAnalyticsConfiguration? _logAnalyticsConfiguration;

    /// <summary>
    /// Creates a new AppLogsConfiguration.
    /// </summary>
    public AppLogsConfiguration()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppLogsConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _destination = DefineProperty<string>("Destination", ["destination"]);
        _logAnalyticsConfiguration = DefineModelProperty<LogAnalyticsConfiguration>("LogAnalyticsConfiguration", ["logAnalyticsConfiguration"]);
    }
}
