// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Provisioning.Primitives;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// App Dapr configuration.
/// </summary>
public partial class AppDaprConfig : ProvisionableConstruct
{
    /// <summary>
    /// Boolean indicating if the Dapr side car is enabled.
    /// </summary>
    public BicepValue<bool> IsEnabled 
    {
        get { Initialize(); return _isEnabled!; }
        set { Initialize(); _isEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isEnabled;

    /// <summary>
    /// Dapr application identifier.
    /// </summary>
    public BicepValue<string> AppId 
    {
        get { Initialize(); return _appId!; }
        set { Initialize(); _appId!.Assign(value); }
    }
    private BicepValue<string>? _appId;

    /// <summary>
    /// Tells Dapr which port your application is listening on.
    /// </summary>
    public BicepValue<int> AppPort 
    {
        get { Initialize(); return _appPort!; }
        set { Initialize(); _appPort!.Assign(value); }
    }
    private BicepValue<int>? _appPort;

    /// <summary>
    /// Dapr max size of http header read buffer in KB to handle when sending
    /// multi-KB headers. Default is 65KB.
    /// </summary>
    public BicepValue<int> HttpReadBufferSize 
    {
        get { Initialize(); return _httpReadBufferSize!; }
        set { Initialize(); _httpReadBufferSize!.Assign(value); }
    }
    private BicepValue<int>? _httpReadBufferSize;

    /// <summary>
    /// Increasing max size of request body http servers parameter in MB to
    /// handle uploading of big files. Default is 4 MB.
    /// </summary>
    public BicepValue<int> HttpMaxRequestSize 
    {
        get { Initialize(); return _httpMaxRequestSize!; }
        set { Initialize(); _httpMaxRequestSize!.Assign(value); }
    }
    private BicepValue<int>? _httpMaxRequestSize;

    /// <summary>
    /// Sets the log level for the Dapr sidecar. Allowed values are debug,
    /// info, warn, error. Default is info.
    /// </summary>
    public BicepValue<AppDaprLogLevel> LogLevel 
    {
        get { Initialize(); return _logLevel!; }
        set { Initialize(); _logLevel!.Assign(value); }
    }
    private BicepValue<AppDaprLogLevel>? _logLevel;

    /// <summary>
    /// Enables API logging for the Dapr sidecar.
    /// </summary>
    public BicepValue<bool> IsApiLoggingEnabled 
    {
        get { Initialize(); return _isApiLoggingEnabled!; }
        set { Initialize(); _isApiLoggingEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isApiLoggingEnabled;

    /// <summary>
    /// Creates a new AppDaprConfig.
    /// </summary>
    public AppDaprConfig()
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppDaprConfig.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        base.DefineProvisionableProperties();
        _isEnabled = DefineProperty<bool>("IsEnabled", ["enabled"]);
        _appId = DefineProperty<string>("AppId", ["appId"]);
        _appPort = DefineProperty<int>("AppPort", ["appPort"]);
        _httpReadBufferSize = DefineProperty<int>("HttpReadBufferSize", ["httpReadBufferSize"]);
        _httpMaxRequestSize = DefineProperty<int>("HttpMaxRequestSize", ["httpMaxRequestSize"]);
        _logLevel = DefineProperty<AppDaprLogLevel>("LogLevel", ["logLevel"]);
        _isApiLoggingEnabled = DefineProperty<bool>("IsApiLoggingEnabled", ["enableApiLogging"]);
    }
}
