// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// KubeEnvironment.
/// </summary>
public partial class KubeEnvironment : ProvisionableResource
{
    /// <summary>
    /// Name of the Kubernetes Environment.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Gets or sets the aks resource id.
    /// </summary>
    public BicepValue<ResourceIdentifier> AksResourceId 
    {
        get { Initialize(); return _aksResourceId!; }
        set { Initialize(); _aksResourceId!.Assign(value); }
    }
    private BicepValue<ResourceIdentifier>? _aksResourceId;

    /// <summary>
    /// Cluster configuration which enables the log daemon to export
    /// app logs to a destination. Currently only
    /// &quot;log-analytics&quot; is             supported
    /// </summary>
    public AppLogsConfiguration AppLogsConfiguration 
    {
        get { Initialize(); return _appLogsConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _appLogsConfiguration, value); }
    }
    private AppLogsConfiguration? _appLogsConfiguration;

    /// <summary>
    /// Cluster configuration which determines the ARC cluster
    /// components types. Eg: Choosing between BuildService kind,
    /// FrontEnd Service ArtifactsStorageType etc.
    /// </summary>
    public ArcConfiguration ArcConfiguration 
    {
        get { Initialize(); return _arcConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _arcConfiguration, value); }
    }
    private ArcConfiguration? _arcConfiguration;

    /// <summary>
    /// Cluster configuration for Container Apps Environments to configure Dapr
    /// Instrumentation Key and VNET Configuration.
    /// </summary>
    public ContainerAppsConfiguration ContainerAppsConfiguration 
    {
        get { Initialize(); return _containerAppsConfiguration!; }
        set { Initialize(); AssignOrReplace(ref _containerAppsConfiguration, value); }
    }
    private ContainerAppsConfiguration? _containerAppsConfiguration;

    /// <summary>
    /// Type of Kubernetes Environment. Only supported for Container App
    /// Environments with value as Managed.
    /// </summary>
    public BicepValue<string> EnvironmentType 
    {
        get { Initialize(); return _environmentType!; }
        set { Initialize(); _environmentType!.Assign(value); }
    }
    private BicepValue<string>? _environmentType;

    /// <summary>
    /// Extended Location.
    /// </summary>
    public ExtendedAzureLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ExtendedAzureLocation? _extendedLocation;

    /// <summary>
    /// Only visible within Vnet/Subnet.
    /// </summary>
    public BicepValue<bool> IsInternalLoadBalancerEnabled 
    {
        get { Initialize(); return _isInternalLoadBalancerEnabled!; }
        set { Initialize(); _isInternalLoadBalancerEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isInternalLoadBalancerEnabled;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Static IP of the KubeEnvironment.
    /// </summary>
    public BicepValue<string> StaticIP 
    {
        get { Initialize(); return _staticIP!; }
        set { Initialize(); _staticIP!.Assign(value); }
    }
    private BicepValue<string>? _staticIP;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Default Domain Name for the cluster.
    /// </summary>
    public BicepValue<string> DefaultDomain 
    {
        get { Initialize(); return _defaultDomain!; }
    }
    private BicepValue<string>? _defaultDomain;

    /// <summary>
    /// Any errors that occurred during deployment or deployment validation.
    /// </summary>
    public BicepValue<string> DeploymentErrors 
    {
        get { Initialize(); return _deploymentErrors!; }
    }
    private BicepValue<string>? _deploymentErrors;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Provisioning state of the Kubernetes Environment.
    /// </summary>
    public BicepValue<KubeEnvironmentProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<KubeEnvironmentProvisioningState>? _provisioningState;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new KubeEnvironment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the KubeEnvironment resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the KubeEnvironment.</param>
    public KubeEnvironment(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/kubeEnvironments", resourceVersion ?? "2021-03-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of KubeEnvironment.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _aksResourceId = DefineProperty<ResourceIdentifier>("AksResourceId", ["properties", "aksResourceID"]);
        _appLogsConfiguration = DefineModelProperty<AppLogsConfiguration>("AppLogsConfiguration", ["properties", "appLogsConfiguration"]);
        _arcConfiguration = DefineModelProperty<ArcConfiguration>("ArcConfiguration", ["properties", "arcConfiguration"]);
        _containerAppsConfiguration = DefineModelProperty<ContainerAppsConfiguration>("ContainerAppsConfiguration", ["properties", "containerAppsConfiguration"]);
        _environmentType = DefineProperty<string>("EnvironmentType", ["properties", "environmentType"]);
        _extendedLocation = DefineModelProperty<ExtendedAzureLocation>("ExtendedLocation", ["extendedLocation"]);
        _isInternalLoadBalancerEnabled = DefineProperty<bool>("IsInternalLoadBalancerEnabled", ["properties", "internalLoadBalancerEnabled"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _staticIP = DefineProperty<string>("StaticIP", ["properties", "staticIp"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _defaultDomain = DefineProperty<string>("DefaultDomain", ["properties", "defaultDomain"], isOutput: true);
        _deploymentErrors = DefineProperty<string>("DeploymentErrors", ["properties", "deploymentErrors"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _provisioningState = DefineProperty<KubeEnvironmentProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported KubeEnvironment resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";
    }

    /// <summary>
    /// Creates a reference to an existing KubeEnvironment.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the KubeEnvironment resource.  This
    /// can be used to refer to the resource in expressions, but is not the
    /// Azure name of the resource.  This value can contain letters, numbers,
    /// and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the KubeEnvironment.</param>
    /// <returns>The existing KubeEnvironment resource.</returns>
    public static KubeEnvironment FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
