// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.Net;

namespace Azure.Provisioning.AppService;

/// <summary>
/// AseV3NetworkingConfiguration.
/// </summary>
public partial class AseV3NetworkingConfiguration : ProvisionableResource
{
    /// <summary>
    /// Gets the Name.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Property to enable and disable new private endpoint connection creation
    /// on ASE.
    /// </summary>
    public BicepValue<bool> AllowNewPrivateEndpointConnections 
    {
        get { Initialize(); return _allowNewPrivateEndpointConnections!; }
        set { Initialize(); _allowNewPrivateEndpointConnections!.Assign(value); }
    }
    private BicepValue<bool>? _allowNewPrivateEndpointConnections;

    /// <summary>
    /// Customer provided Inbound IP Address. Only able to be set on Ase create.
    /// </summary>
    public BicepValue<string> InboundIPAddressOverride 
    {
        get { Initialize(); return _inboundIPAddressOverride!; }
        set { Initialize(); _inboundIPAddressOverride!.Assign(value); }
    }
    private BicepValue<string>? _inboundIPAddressOverride;

    /// <summary>
    /// Property to enable and disable FTP on ASEV3.
    /// </summary>
    public BicepValue<bool> IsFtpEnabled 
    {
        get { Initialize(); return _isFtpEnabled!; }
        set { Initialize(); _isFtpEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isFtpEnabled;

    /// <summary>
    /// Property to enable and disable Remote Debug on ASEV3.
    /// </summary>
    public BicepValue<bool> IsRemoteDebugEnabled 
    {
        get { Initialize(); return _isRemoteDebugEnabled!; }
        set { Initialize(); _isRemoteDebugEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isRemoteDebugEnabled;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Gets the external inbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> ExternalInboundIPAddresses 
    {
        get { Initialize(); return _externalInboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _externalInboundIPAddresses;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the internal inbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> InternalInboundIPAddresses 
    {
        get { Initialize(); return _internalInboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _internalInboundIPAddresses;

    /// <summary>
    /// Gets the linux outbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> LinuxOutboundIPAddresses 
    {
        get { Initialize(); return _linuxOutboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _linuxOutboundIPAddresses;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Gets the windows outbound ip addresses.
    /// </summary>
    public BicepList<IPAddress> WindowsOutboundIPAddresses 
    {
        get { Initialize(); return _windowsOutboundIPAddresses!; }
    }
    private BicepList<IPAddress>? _windowsOutboundIPAddresses;

    /// <summary>
    /// Gets or sets a reference to the parent AppServiceEnvironment.
    /// </summary>
    public AppServiceEnvironment? Parent
    {
        get { Initialize(); return _parent!.Value; }
        set { Initialize(); _parent!.Value = value; }
    }
    private ResourceReference<AppServiceEnvironment>? _parent;

    /// <summary>
    /// Creates a new AseV3NetworkingConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AseV3NetworkingConfiguration
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AseV3NetworkingConfiguration.</param>
    public AseV3NetworkingConfiguration(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/hostingEnvironments/configurations", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AseV3NetworkingConfiguration.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isOutput: true);
        _allowNewPrivateEndpointConnections = DefineProperty<bool>("AllowNewPrivateEndpointConnections", ["properties", "allowNewPrivateEndpointConnections"]);
        _inboundIPAddressOverride = DefineProperty<string>("InboundIPAddressOverride", ["properties", "inboundIpAddressOverride"]);
        _isFtpEnabled = DefineProperty<bool>("IsFtpEnabled", ["properties", "ftpEnabled"]);
        _isRemoteDebugEnabled = DefineProperty<bool>("IsRemoteDebugEnabled", ["properties", "remoteDebugEnabled"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _externalInboundIPAddresses = DefineListProperty<IPAddress>("ExternalInboundIPAddresses", ["properties", "externalInboundIpAddresses"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _internalInboundIPAddresses = DefineListProperty<IPAddress>("InternalInboundIPAddresses", ["properties", "internalInboundIpAddresses"], isOutput: true);
        _linuxOutboundIPAddresses = DefineListProperty<IPAddress>("LinuxOutboundIPAddresses", ["properties", "linuxOutboundIpAddresses"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
        _windowsOutboundIPAddresses = DefineListProperty<IPAddress>("WindowsOutboundIPAddresses", ["properties", "windowsOutboundIpAddresses"], isOutput: true);
        _parent = DefineResource<AppServiceEnvironment>("Parent", ["parent"], isRequired: true);
    }

    /// <summary>
    /// Supported AseV3NetworkingConfiguration resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2019-02-01.
        /// </summary>
        public static readonly string V2019_02_01 = "2019-02-01";

        /// <summary>
        /// 2019-01-01.
        /// </summary>
        public static readonly string V2019_01_01 = "2019-01-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-08-01.
        /// </summary>
        public static readonly string V2018_08_01 = "2018-08-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing AseV3NetworkingConfiguration.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AseV3NetworkingConfiguration
    /// resource.  This can be used to refer to the resource in expressions,
    /// but is not the Azure name of the resource.  This value can contain
    /// letters, numbers, and underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AseV3NetworkingConfiguration.</param>
    /// <returns>The existing AseV3NetworkingConfiguration resource.</returns>
    public static AseV3NetworkingConfiguration FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
