// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;

namespace Azure.Provisioning.AppService;

/// <summary>
/// AppServicePlanVirtualNetworkConnectionGateway.
/// </summary>
public partial class AppServicePlanVirtualNetworkConnectionGateway : ProvisionableResource
{
    /// <summary>
    /// Name of the gateway. Only the &apos;primary&apos; gateway is supported.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// The Virtual Network name.
    /// </summary>
    public BicepValue<string> VnetName 
    {
        get { Initialize(); return _vnetName!; }
        set { Initialize(); _vnetName!.Assign(value); }
    }
    private BicepValue<string>? _vnetName;

    /// <summary>
    /// The URI where the VPN package can be downloaded.
    /// </summary>
    public BicepValue<Uri> VpnPackageUri 
    {
        get { Initialize(); return _vpnPackageUri!; }
        set { Initialize(); _vpnPackageUri!.Assign(value); }
    }
    private BicepValue<Uri>? _vpnPackageUri;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AppServicePlanVirtualNetworkConnectionGateway.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// AppServicePlanVirtualNetworkConnectionGateway resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServicePlanVirtualNetworkConnectionGateway.</param>
    public AppServicePlanVirtualNetworkConnectionGateway(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/serverfarms/virtualNetworkConnections/gateways", resourceVersion)
    {
    }

    /// <summary>
    /// Define all the provisionable properties of
    /// AppServicePlanVirtualNetworkConnectionGateway.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _vnetName = DefineProperty<string>("VnetName", ["properties", "vnetName"]);
        _vpnPackageUri = DefineProperty<Uri>("VpnPackageUri", ["properties", "vpnPackageUri"]);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Creates a reference to an existing
    /// AppServicePlanVirtualNetworkConnectionGateway.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the
    /// AppServicePlanVirtualNetworkConnectionGateway resource.  This can be
    /// used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServicePlanVirtualNetworkConnectionGateway.</param>
    /// <returns>The existing AppServicePlanVirtualNetworkConnectionGateway resource.</returns>
    public static AppServicePlanVirtualNetworkConnectionGateway FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };
}
