// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable enable

using Azure.Core;
using Azure.Provisioning;
using Azure.Provisioning.Primitives;
using Azure.Provisioning.Resources;
using System;
using System.ComponentModel;

namespace Azure.Provisioning.AppService;

/// <summary>
/// AppServicePlan.
/// </summary>
public partial class AppServicePlan : ProvisionableResource
{
    /// <summary>
    /// Name of the App Service plan.
    /// </summary>
    public BicepValue<string> Name 
    {
        get { Initialize(); return _name!; }
        set { Initialize(); _name!.Assign(value); }
    }
    private BicepValue<string>? _name;

    /// <summary>
    /// Gets or sets the Location.
    /// </summary>
    public BicepValue<AzureLocation> Location 
    {
        get { Initialize(); return _location!; }
        set { Initialize(); _location!.Assign(value); }
    }
    private BicepValue<AzureLocation>? _location;

    /// <summary>
    /// Extended Location.
    /// </summary>
    public ExtendedAzureLocation ExtendedLocation 
    {
        get { Initialize(); return _extendedLocation!; }
        set { Initialize(); AssignOrReplace(ref _extendedLocation, value); }
    }
    private ExtendedAzureLocation? _extendedLocation;

    /// <summary>
    /// The time when the server farm free offer expires.
    /// </summary>
    public BicepValue<DateTimeOffset> FreeOfferExpireOn 
    {
        get { Initialize(); return _freeOfferExpireOn!; }
        set { Initialize(); _freeOfferExpireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _freeOfferExpireOn;

    /// <summary>
    /// Specification for the App Service Environment to use for the App
    /// Service plan.
    /// </summary>
    public HostingEnvironmentProfile HostingEnvironmentProfile 
    {
        get { Initialize(); return _hostingEnvironmentProfile!; }
        set { Initialize(); AssignOrReplace(ref _hostingEnvironmentProfile, value); }
    }
    private HostingEnvironmentProfile? _hostingEnvironmentProfile;

    /// <summary>
    /// ServerFarm supports ElasticScale. Apps in this plan will scale as if
    /// the ServerFarm was ElasticPremium sku.
    /// </summary>
    public BicepValue<bool> IsElasticScaleEnabled 
    {
        get { Initialize(); return _isElasticScaleEnabled!; }
        set { Initialize(); _isElasticScaleEnabled!.Assign(value); }
    }
    private BicepValue<bool>? _isElasticScaleEnabled;

    /// <summary>
    /// If Hyper-V container app service plan &lt;code&gt;true&lt;/code&gt;,
    /// &lt;code&gt;false&lt;/code&gt; otherwise.
    /// </summary>
    public BicepValue<bool> IsHyperV 
    {
        get { Initialize(); return _isHyperV!; }
        set { Initialize(); _isHyperV!.Assign(value); }
    }
    private BicepValue<bool>? _isHyperV;

    /// <summary>
    /// If &lt;code&gt;true&lt;/code&gt;, apps assigned to this App Service
    /// plan can be scaled independently.             If
    /// &lt;code&gt;false&lt;/code&gt;, apps assigned to this App Service plan
    /// will scale to all instances of the plan.
    /// </summary>
    public BicepValue<bool> IsPerSiteScaling 
    {
        get { Initialize(); return _isPerSiteScaling!; }
        set { Initialize(); _isPerSiteScaling!.Assign(value); }
    }
    private BicepValue<bool>? _isPerSiteScaling;

    /// <summary>
    /// If Linux app service plan &lt;code&gt;true&lt;/code&gt;,
    /// &lt;code&gt;false&lt;/code&gt; otherwise.
    /// </summary>
    public BicepValue<bool> IsReserved 
    {
        get { Initialize(); return _isReserved!; }
        set { Initialize(); _isReserved!.Assign(value); }
    }
    private BicepValue<bool>? _isReserved;

    /// <summary>
    /// If &lt;code&gt;true&lt;/code&gt;, this App Service Plan owns spot
    /// instances.
    /// </summary>
    public BicepValue<bool> IsSpot 
    {
        get { Initialize(); return _isSpot!; }
        set { Initialize(); _isSpot!.Assign(value); }
    }
    private BicepValue<bool>? _isSpot;

    /// <summary>
    /// Obsolete: If Hyper-V container app service plan
    /// &lt;code&gt;true&lt;/code&gt;, &lt;code&gt;false&lt;/code&gt;
    /// otherwise.
    /// </summary>
    public BicepValue<bool> IsXenon 
    {
        get { Initialize(); return _isXenon!; }
        set { Initialize(); _isXenon!.Assign(value); }
    }
    private BicepValue<bool>? _isXenon;

    /// <summary>
    /// If &lt;code&gt;true&lt;/code&gt;, this App Service Plan will perform
    /// availability zone balancing.             If
    /// &lt;code&gt;false&lt;/code&gt;, this App Service Plan will not perform
    /// availability zone balancing.
    /// </summary>
    public BicepValue<bool> IsZoneRedundant 
    {
        get { Initialize(); return _isZoneRedundant!; }
        set { Initialize(); _isZoneRedundant!.Assign(value); }
    }
    private BicepValue<bool>? _isZoneRedundant;

    /// <summary>
    /// Kind of resource.
    /// </summary>
    public BicepValue<string> Kind 
    {
        get { Initialize(); return _kind!; }
        set { Initialize(); _kind!.Assign(value); }
    }
    private BicepValue<string>? _kind;

    /// <summary>
    /// Specification for the Kubernetes Environment to use for the App Service
    /// plan.
    /// </summary>
    public KubeEnvironmentProfile KubeEnvironmentProfile 
    {
        get { Initialize(); return _kubeEnvironmentProfile!; }
        set { Initialize(); AssignOrReplace(ref _kubeEnvironmentProfile, value); }
    }
    private KubeEnvironmentProfile? _kubeEnvironmentProfile;

    /// <summary>
    /// Maximum number of total workers allowed for this ElasticScaleEnabled
    /// App Service Plan.
    /// </summary>
    public BicepValue<int> MaximumElasticWorkerCount 
    {
        get { Initialize(); return _maximumElasticWorkerCount!; }
        set { Initialize(); _maximumElasticWorkerCount!.Assign(value); }
    }
    private BicepValue<int>? _maximumElasticWorkerCount;

    /// <summary>
    /// Description of a SKU for a scalable resource.
    /// </summary>
    public AppServiceSkuDescription Sku 
    {
        get { Initialize(); return _sku!; }
        set { Initialize(); AssignOrReplace(ref _sku, value); }
    }
    private AppServiceSkuDescription? _sku;

    /// <summary>
    /// The time when the server farm expires. Valid only if it is a spot
    /// server farm.
    /// </summary>
    public BicepValue<DateTimeOffset> SpotExpireOn 
    {
        get { Initialize(); return _spotExpireOn!; }
        set { Initialize(); _spotExpireOn!.Assign(value); }
    }
    private BicepValue<DateTimeOffset>? _spotExpireOn;

    /// <summary>
    /// Gets or sets the Tags.
    /// </summary>
    public BicepDictionary<string> Tags 
    {
        get { Initialize(); return _tags!; }
        set { Initialize(); _tags!.Assign(value); }
    }
    private BicepDictionary<string>? _tags;

    /// <summary>
    /// Scaling worker count.
    /// </summary>
    public BicepValue<int> TargetWorkerCount 
    {
        get { Initialize(); return _targetWorkerCount!; }
        set { Initialize(); _targetWorkerCount!.Assign(value); }
    }
    private BicepValue<int>? _targetWorkerCount;

    /// <summary>
    /// Scaling worker size ID.
    /// </summary>
    public BicepValue<int> TargetWorkerSizeId 
    {
        get { Initialize(); return _targetWorkerSizeId!; }
        set { Initialize(); _targetWorkerSizeId!.Assign(value); }
    }
    private BicepValue<int>? _targetWorkerSizeId;

    /// <summary>
    /// Target worker tier assigned to the App Service plan.
    /// </summary>
    public BicepValue<string> WorkerTierName 
    {
        get { Initialize(); return _workerTierName!; }
        set { Initialize(); _workerTierName!.Assign(value); }
    }
    private BicepValue<string>? _workerTierName;

    /// <summary>
    /// Geographical location for the App Service plan.
    /// </summary>
    public BicepValue<string> GeoRegion 
    {
        get { Initialize(); return _geoRegion!; }
    }
    private BicepValue<string>? _geoRegion;

    /// <summary>
    /// Gets the Id.
    /// </summary>
    public BicepValue<ResourceIdentifier> Id 
    {
        get { Initialize(); return _id!; }
    }
    private BicepValue<ResourceIdentifier>? _id;

    /// <summary>
    /// Maximum number of instances that can be assigned to this App Service
    /// plan.
    /// </summary>
    public BicepValue<int> MaximumNumberOfWorkers 
    {
        get { Initialize(); return _maximumNumberOfWorkers!; }
    }
    private BicepValue<int>? _maximumNumberOfWorkers;

    /// <summary>
    /// Number of apps assigned to this App Service plan.
    /// </summary>
    public BicepValue<int> NumberOfSites 
    {
        get { Initialize(); return _numberOfSites!; }
    }
    private BicepValue<int>? _numberOfSites;

    /// <summary>
    /// The number of instances that are assigned to this App Service plan.
    /// </summary>
    public BicepValue<int> NumberOfWorkers 
    {
        get { Initialize(); return _numberOfWorkers!; }
    }
    private BicepValue<int>? _numberOfWorkers;

    /// <summary>
    /// Provisioning state of the App Service Plan.
    /// </summary>
    public BicepValue<ProvisioningState> ProvisioningState 
    {
        get { Initialize(); return _provisioningState!; }
    }
    private BicepValue<ProvisioningState>? _provisioningState;

    /// <summary>
    /// Resource group of the App Service plan.
    /// </summary>
    public BicepValue<string> ResourceGroup 
    {
        get { Initialize(); return _resourceGroup!; }
    }
    private BicepValue<string>? _resourceGroup;

    /// <summary>
    /// App Service plan status.
    /// </summary>
    public BicepValue<AppServicePlanStatus> Status 
    {
        get { Initialize(); return _status!; }
    }
    private BicepValue<AppServicePlanStatus>? _status;

    /// <summary>
    /// App Service plan subscription.
    /// </summary>
    public BicepValue<string> Subscription 
    {
        get { Initialize(); return _subscription!; }
    }
    private BicepValue<string>? _subscription;

    /// <summary>
    /// Gets the SystemData.
    /// </summary>
    public SystemData SystemData 
    {
        get { Initialize(); return _systemData!; }
    }
    private SystemData? _systemData;

    /// <summary>
    /// Creates a new AppServicePlan.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppServicePlan resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServicePlan.</param>
    public AppServicePlan(string bicepIdentifier, string? resourceVersion = default)
        : base(bicepIdentifier, "Microsoft.Web/serverfarms", resourceVersion ?? "2024-04-01")
    {
    }

    /// <summary>
    /// Define all the provisionable properties of AppServicePlan.
    /// </summary>
    protected override void DefineProvisionableProperties()
    {
        _name = DefineProperty<string>("Name", ["name"], isRequired: true);
        _location = DefineProperty<AzureLocation>("Location", ["location"], isRequired: true);
        _extendedLocation = DefineModelProperty<ExtendedAzureLocation>("ExtendedLocation", ["extendedLocation"]);
        _freeOfferExpireOn = DefineProperty<DateTimeOffset>("FreeOfferExpireOn", ["properties", "freeOfferExpirationTime"]);
        _hostingEnvironmentProfile = DefineModelProperty<HostingEnvironmentProfile>("HostingEnvironmentProfile", ["properties", "hostingEnvironmentProfile"]);
        _isElasticScaleEnabled = DefineProperty<bool>("IsElasticScaleEnabled", ["properties", "elasticScaleEnabled"]);
        _isHyperV = DefineProperty<bool>("IsHyperV", ["properties", "hyperV"]);
        _isPerSiteScaling = DefineProperty<bool>("IsPerSiteScaling", ["properties", "perSiteScaling"]);
        _isReserved = DefineProperty<bool>("IsReserved", ["properties", "reserved"]);
        _isSpot = DefineProperty<bool>("IsSpot", ["properties", "isSpot"]);
        _isXenon = DefineProperty<bool>("IsXenon", ["properties", "isXenon"]);
        _isZoneRedundant = DefineProperty<bool>("IsZoneRedundant", ["properties", "zoneRedundant"]);
        _kind = DefineProperty<string>("Kind", ["kind"]);
        _kubeEnvironmentProfile = DefineModelProperty<KubeEnvironmentProfile>("KubeEnvironmentProfile", ["properties", "kubeEnvironmentProfile"]);
        _maximumElasticWorkerCount = DefineProperty<int>("MaximumElasticWorkerCount", ["properties", "maximumElasticWorkerCount"]);
        _sku = DefineModelProperty<AppServiceSkuDescription>("Sku", ["sku"]);
        _spotExpireOn = DefineProperty<DateTimeOffset>("SpotExpireOn", ["properties", "spotExpirationTime"]);
        _tags = DefineDictionaryProperty<string>("Tags", ["tags"]);
        _targetWorkerCount = DefineProperty<int>("TargetWorkerCount", ["properties", "targetWorkerCount"]);
        _targetWorkerSizeId = DefineProperty<int>("TargetWorkerSizeId", ["properties", "targetWorkerSizeId"]);
        _workerTierName = DefineProperty<string>("WorkerTierName", ["properties", "workerTierName"]);
        _geoRegion = DefineProperty<string>("GeoRegion", ["properties", "geoRegion"], isOutput: true);
        _id = DefineProperty<ResourceIdentifier>("Id", ["id"], isOutput: true);
        _maximumNumberOfWorkers = DefineProperty<int>("MaximumNumberOfWorkers", ["properties", "maximumNumberOfWorkers"], isOutput: true);
        _numberOfSites = DefineProperty<int>("NumberOfSites", ["properties", "numberOfSites"], isOutput: true);
        _numberOfWorkers = DefineProperty<int>("NumberOfWorkers", ["properties", "numberOfWorkers"], isOutput: true);
        _provisioningState = DefineProperty<ProvisioningState>("ProvisioningState", ["properties", "provisioningState"], isOutput: true);
        _resourceGroup = DefineProperty<string>("ResourceGroup", ["properties", "resourceGroup"], isOutput: true);
        _status = DefineProperty<AppServicePlanStatus>("Status", ["properties", "status"], isOutput: true);
        _subscription = DefineProperty<string>("Subscription", ["properties", "subscription"], isOutput: true);
        _systemData = DefineModelProperty<SystemData>("SystemData", ["systemData"], isOutput: true);
    }

    /// <summary>
    /// Supported AppServicePlan resource versions.
    /// </summary>
    public static class ResourceVersions
    {
        /// <summary>
        /// 2024-04-01.
        /// </summary>
        public static readonly string V2024_04_01 = "2024-04-01";

        /// <summary>
        /// 2023-12-01.
        /// </summary>
        public static readonly string V2023_12_01 = "2023-12-01";

        /// <summary>
        /// 2023-01-01.
        /// </summary>
        public static readonly string V2023_01_01 = "2023-01-01";

        /// <summary>
        /// 2022-09-01.
        /// </summary>
        public static readonly string V2022_09_01 = "2022-09-01";

        /// <summary>
        /// 2022-03-01.
        /// </summary>
        public static readonly string V2022_03_01 = "2022-03-01";

        /// <summary>
        /// 2021-03-01.
        /// </summary>
        public static readonly string V2021_03_01 = "2021-03-01";

        /// <summary>
        /// 2021-02-01.
        /// </summary>
        public static readonly string V2021_02_01 = "2021-02-01";

        /// <summary>
        /// 2021-01-15.
        /// </summary>
        public static readonly string V2021_01_15 = "2021-01-15";

        /// <summary>
        /// 2021-01-01.
        /// </summary>
        public static readonly string V2021_01_01 = "2021-01-01";

        /// <summary>
        /// 2020-12-01.
        /// </summary>
        public static readonly string V2020_12_01 = "2020-12-01";

        /// <summary>
        /// 2020-10-01.
        /// </summary>
        public static readonly string V2020_10_01 = "2020-10-01";

        /// <summary>
        /// 2020-09-01.
        /// </summary>
        public static readonly string V2020_09_01 = "2020-09-01";

        /// <summary>
        /// 2020-06-01.
        /// </summary>
        public static readonly string V2020_06_01 = "2020-06-01";

        /// <summary>
        /// 2019-08-01.
        /// </summary>
        public static readonly string V2019_08_01 = "2019-08-01";

        /// <summary>
        /// 2018-11-01.
        /// </summary>
        public static readonly string V2018_11_01 = "2018-11-01";

        /// <summary>
        /// 2018-02-01.
        /// </summary>
        public static readonly string V2018_02_01 = "2018-02-01";

        /// <summary>
        /// 2017-08-01.
        /// </summary>
        public static readonly string V2017_08_01 = "2017-08-01";

        /// <summary>
        /// 2016-09-01.
        /// </summary>
        public static readonly string V2016_09_01 = "2016-09-01";

        /// <summary>
        /// 2016-03-01.
        /// </summary>
        public static readonly string V2016_03_01 = "2016-03-01";

        /// <summary>
        /// 2015-08-01.
        /// </summary>
        public static readonly string V2015_08_01 = "2015-08-01";

        /// <summary>
        /// 2015-07-01.
        /// </summary>
        public static readonly string V2015_07_01 = "2015-07-01";

        /// <summary>
        /// 2015-06-01.
        /// </summary>
        public static readonly string V2015_06_01 = "2015-06-01";

        /// <summary>
        /// 2015-05-01.
        /// </summary>
        public static readonly string V2015_05_01 = "2015-05-01";

        /// <summary>
        /// 2015-04-01.
        /// </summary>
        public static readonly string V2015_04_01 = "2015-04-01";

        /// <summary>
        /// 2015-02-01.
        /// </summary>
        public static readonly string V2015_02_01 = "2015-02-01";

        /// <summary>
        /// 2014-11-01.
        /// </summary>
        public static readonly string V2014_11_01 = "2014-11-01";

        /// <summary>
        /// 2014-06-01.
        /// </summary>
        public static readonly string V2014_06_01 = "2014-06-01";

        /// <summary>
        /// 2014-04-01.
        /// </summary>
        public static readonly string V2014_04_01 = "2014-04-01";
    }

    /// <summary>
    /// Creates a reference to an existing AppServicePlan.
    /// </summary>
    /// <param name="bicepIdentifier">
    /// The the Bicep identifier name of the AppServicePlan resource.  This can
    /// be used to refer to the resource in expressions, but is not the Azure
    /// name of the resource.  This value can contain letters, numbers, and
    /// underscores.
    /// </param>
    /// <param name="resourceVersion">Version of the AppServicePlan.</param>
    /// <returns>The existing AppServicePlan resource.</returns>
    public static AppServicePlan FromExisting(string bicepIdentifier, string? resourceVersion = default) =>
        new(bicepIdentifier, resourceVersion) { IsExistingResource = true };

    /// <summary>
    /// Get the requirements for naming this AppServicePlan resource.
    /// </summary>
    /// <returns>Naming requirements.</returns>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public override ResourceNameRequirements GetResourceNameRequirements() =>
        new(minLength: 1, maxLength: 60, validCharacters: ResourceNameCharacters.LowercaseLetters | ResourceNameCharacters.UppercaseLetters | ResourceNameCharacters.Numbers | ResourceNameCharacters.Hyphen);
}
